/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api;

import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.service.AccountService;
import com.alipay.mychain.sdk.api.service.AdminService;
import com.alipay.mychain.sdk.api.service.ConfidentialService;
import com.alipay.mychain.sdk.api.service.ContractService;
import com.alipay.mychain.sdk.api.service.EnvelopeService;
import com.alipay.mychain.sdk.api.service.EventService;
import com.alipay.mychain.sdk.api.service.QueryService;
import com.alipay.mychain.sdk.api.service.ServiceManager;
import com.alipay.mychain.sdk.api.service.SpvService;
import com.alipay.mychain.sdk.network.HeartBeatTask;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.network.NetworkFactory;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import io.netty.util.internal.NativeLibraryLoader;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MychainClient {
    private Boolean isStart = Boolean.FALSE;
    private ClientEnv env;
    private ServiceManager serviceManager;
    private INetwork network;
    private TimerTaskManager timerTaskManager;

    public boolean init(ClientEnv env) {
        if (this.isStart.booleanValue() || env == null) {
            return false;
        }
        if (env.getLogger() == null) {
            return false;
        }
        try {
            if (env.getNeedPrivacy().booleanValue()) {
                NativeLibraryLoader.loadFirstAvailable((ClassLoader)MychainClient.class.getClassLoader(), (String[])new String[]{"PrivacyLib"});
            }
            this.env = env;
            this.network = NetworkFactory.getClientNetwork(env.getNetworkOption().getNetworkType());
            this.timerTaskManager = new TimerTaskManager();
            this.timerTaskManager.startTimerTask();
            boolean result = this.network.startup(this.env.getNetworkOption(), this.env.getSslOption(), this.timerTaskManager, this.env.getLogger());
            if (!result) {
                if (this.network != null) {
                    this.network.shutDown();
                }
                if (this.timerTaskManager != null) {
                    this.timerTaskManager.shutdown();
                }
                return false;
            }
            HeartBeatTask task = new HeartBeatTask(this.network, this.env.getLogger(), this.env.getNetworkOption().getHeartbeatIntervalMs(), this.env.getNetworkOption().getRetryHeartbeatTimes());
            this.timerTaskManager.registerTask(task);
            this.serviceManager = new ServiceManager(this.network, this.timerTaskManager, this.env);
            this.serviceManager.startServices(this);
        }
        catch (Throwable cause) {
            env.getLogger().error("init caught exception, cause: {}\n{}", (Object)cause.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)cause));
            return false;
        }
        this.isStart = true;
        return true;
    }

    public boolean shutDown() {
        if (!this.isStart.booleanValue()) {
            return false;
        }
        if (this.serviceManager != null) {
            this.serviceManager.stopServices();
        }
        if (this.network != null) {
            this.network.shutDown();
        }
        if (this.timerTaskManager != null) {
            this.timerTaskManager.shutdown();
        }
        this.isStart = false;
        return true;
    }

    public AccountService getAccountService() {
        return this.serviceManager.getAccountService();
    }

    public ContractService getContractService() {
        return this.serviceManager.getContractService();
    }

    public QueryService getQueryService() {
        return this.serviceManager.getQueryService();
    }

    public AdminService getAdminService() {
        return this.serviceManager.getAdminService();
    }

    public EventService getEventService() {
        return this.serviceManager.getEventService();
    }

    public ConfidentialService getConfidentialService() {
        return this.serviceManager.getConfidentialService();
    }

    public EnvelopeService getEnvelopeService() {
        return this.serviceManager.getEnvelopeService();
    }

    public SpvService getSPVService() {
        return this.serviceManager.getSPVService();
    }

    public ClientEnv getMychainClientEnv() {
        return this.env;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public TimerTaskManager getTimerTaskManager() {
        return this.timerTaskManager;
    }
}

