/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.cipher.CipherBase;
import com.alipay.mychain.sdk.crypto.envelope.EccK1EnvelopeSGX;
import com.alipay.mychain.sdk.crypto.envelope.EccK1EnvelopeV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.envelope.RSAEnvelopeSGX;
import com.alipay.mychain.sdk.crypto.keyoperator.KeyOperator;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.EccK1KDFV1;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.crypto.pkeycipher.RSAPkeyCipherV0;
import com.alipay.mychain.sdk.crypto.signer.EccK1KeypairV0;
import com.alipay.mychain.sdk.crypto.signer.EccR1SignerV1;
import com.alipay.mychain.sdk.crypto.signer.RsaSignerV1;
import com.alipay.mychain.sdk.crypto.signer.SM2SignerV1;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.utils.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MyCrypto {
    private static MyCrypto instance;

    private MyCrypto() {
    }

    public static MyCrypto getInstance() {
        if (instance == null) {
            instance = new MyCrypto();
        }
        return instance;
    }

    public KeyOperator getKeyOperator(KeyTypeEnum type) {
        if (type.getValue() > 0 && type.getValue() <= 1000) {
            return new Pkcs8KeyOperator();
        }
        return null;
    }

    public SignerBase createSigner(Keypair keypair) {
        if (keypair == null || keypair.getType() == KeyTypeEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair!");
        }
        AlgoIdEnum algoIdEnum = AlgoIdEnum.getSignerAlgoByKeyType(keypair.getType());
        if (algoIdEnum == null || algoIdEnum == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.OTHERS, "Unsupported signer by key type :: " + (Object)((Object)keypair.getType()));
        }
        try {
            Class signer = this.getSignerFromAlgo(algoIdEnum);
            return (SignerBase)ReflectionUtil.newInstance(signer, keypair);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public SignerBase createSignerByAlgo(AlgoIdEnum algoIdEnum) {
        if (algoIdEnum == null || algoIdEnum != AlgoIdEnum.SIGNER_ECCK1_LOCAL_V0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid algoid, just support SIGNER_ECCK1_LOCAL_V0");
        }
        try {
            Class signer = this.getSignerFromAlgo(algoIdEnum);
            return (SignerBase)ReflectionUtil.newInstance(signer, new Object[0]);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public PkeyCipherBase createPkeyCipher(Keypair keypair) {
        if (keypair == null || keypair.getType() == KeyTypeEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair!");
        }
        AlgoIdEnum algoIdEnum = AlgoIdEnum.getPkeyCipherAlgoByKeyType(keypair.getType());
        if (algoIdEnum == null || algoIdEnum == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.OTHERS, "Unsupported pkeycipher by key type :: " + (Object)((Object)keypair.getType()));
        }
        try {
            Class pkeyCipher = this.getPkeyCipherFromAlgo(algoIdEnum);
            return (PkeyCipherBase)ReflectionUtil.newInstance(pkeyCipher, keypair);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public CipherBase createCipher(AlgoIdEnum algoId, byte[] key) {
        if (algoId == null || algoId == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid algoId!");
        }
        try {
            Class cipher = this.getCipherFromAlgo(algoId);
            return (CipherBase)ReflectionUtil.newInstance(cipher, new Object[]{key});
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public EnvelopeBase createEnvelope(Keypair keypair) {
        if (keypair == null || keypair.getType() == KeyTypeEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair!");
        }
        AlgoIdEnum algoIdEnum = AlgoIdEnum.getEnvelopeAlgoByKeyType(keypair.getType());
        if (algoIdEnum == null || algoIdEnum == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.OTHERS, "Unsupported envelope by key type :: " + (Object)((Object)keypair.getType()));
        }
        try {
            Class envelopeType = this.getEnvelopeFromAlgo(algoIdEnum);
            EnvelopeBase envelopeBase = (EnvelopeBase)ReflectionUtil.newInstance(envelopeType, new Object[0]);
            envelopeBase.setPrivkey(keypair);
            return envelopeBase;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public EnvelopeBase createEnvelopeByAlgo(AlgoIdEnum algoIdEnum) {
        if (algoIdEnum == null || algoIdEnum == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid algId!");
        }
        try {
            Class envelopeType = this.getEnvelopeFromAlgo(algoIdEnum);
            EnvelopeBase envelopeBase = (EnvelopeBase)ReflectionUtil.newInstance(envelopeType, new Object[0]);
            return envelopeBase;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public EnvelopeBase createEnvelope(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.isEmpty()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkeyList is empty");
        }
        AlgoIdEnum algoIdEnum = AlgoIdEnum.getEnvelopeAlgoByKeyType(pubkeyList.get(0).getType());
        if (algoIdEnum == null || algoIdEnum == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.OTHERS, "Unsupported envelope by key type :: " + (Object)((Object)pubkeyList.get(0).getType()));
        }
        try {
            Class envelopeType = this.getEnvelopeFromAlgo(algoIdEnum);
            EnvelopeBase envelopeBase = (EnvelopeBase)ReflectionUtil.newInstance(envelopeType, new Object[0]);
            envelopeBase.setPubkeyList(pubkeyList);
            return envelopeBase;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public EnvelopeBase createEnvelope(PkeyCipherBase cipher) {
        if (cipher == null || cipher.getAlgo() == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher!");
        }
        AlgoIdEnum algoIdEnum = this.cipher2Envelope(cipher.getAlgo());
        if (algoIdEnum == null || algoIdEnum == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.OTHERS, "Unsupported envelope by cipher algoId :: " + (Object)((Object)cipher.getAlgo()));
        }
        try {
            Class envelopeType = this.getEnvelopeFromAlgo(algoIdEnum);
            EnvelopeBase envelopeBase = (EnvelopeBase)ReflectionUtil.newInstance(envelopeType, new Object[0]);
            envelopeBase.setPrivkey(cipher);
            return envelopeBase;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public EnvelopeBase createEnvelopeByCipherList(List<PkeyCipherBase> pubkeyList) {
        if (pubkeyList == null || pubkeyList.isEmpty()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkeyList is empty");
        }
        AlgoIdEnum algoIdEnum = this.cipher2Envelope(pubkeyList.get(0).getAlgo());
        if (algoIdEnum == null || algoIdEnum == AlgoIdEnum.UNKNOWN) {
            throw new MychainSdkException(ErrorCode.OTHERS, "Unsupported envelope by cipher algoId :: " + (Object)((Object)pubkeyList.get(0).getAlgo()));
        }
        try {
            Class envelopeType = this.getEnvelopeFromAlgo(algoIdEnum);
            EnvelopeBase envelopeBase = (EnvelopeBase)ReflectionUtil.newInstance(envelopeType, new Object[0]);
            envelopeBase.setPkeyCipherList(pubkeyList);
            return envelopeBase;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public boolean decodeVerify(byte[] pubkey, byte[] sig, byte[] msg) {
        if (ArrayUtils.isEmpty((byte[])pubkey)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkey is empty!");
        }
        if (ArrayUtils.isEmpty((byte[])sig)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "sig is empty!");
        }
        if (ArrayUtils.isEmpty((byte[])msg)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "msg is empty!");
        }
        if (sig.length == 65) {
            if (pubkey.length != 64) {
                return false;
            }
            Keypair keypair = new Keypair(pubkey);
            SignerBase signer = this.createSigner(keypair);
            if (signer == null) {
                return false;
            }
            return signer.verify(sig, msg);
        }
        if (sig.length > 6) {
            Keypair keypair = new Keypair(pubkey);
            SignerBase signer = this.createSigner(AlgoIdEnum.valueOf(sig), keypair);
            if (signer == null) {
                return false;
            }
            return signer.verify(sig, msg);
        }
        return false;
    }

    public byte[] decodeRecover(byte[] sig, byte[] msg) {
        if (ArrayUtils.isEmpty((byte[])sig) || sig.length != 65) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid sig!");
        }
        if (ArrayUtils.isEmpty((byte[])msg) || msg.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid msg!");
        }
        SignerBase signer = this.createSignerByAlgo(AlgoIdEnum.SIGNER_ECCK1_LOCAL_V0);
        if (signer == null) {
            return null;
        }
        return signer.recover(sig, msg);
    }

    public HashSet<Integer> multiVerify(List<byte[]> pubkeyList, List<byte[]> signatureList, byte[] msg) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkeyList is empty!");
        }
        if (signatureList == null || signatureList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "signatureList is empty!");
        }
        if (ArrayUtils.isEmpty((byte[])msg)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "msg is empty!");
        }
        HashSet<Integer> pubkeyMatchedIndex = new HashSet<Integer>();
        HashMap pubkeyMap = new HashMap();
        if (pubkeyList.size() == 1) {
            byte[] signature;
            byte[] pubkey = pubkeyList.get(0);
            if (this.decodeVerify(pubkey, signature = signatureList.get(0), msg)) {
                pubkeyMatchedIndex.add(0);
            }
        } else {
            for (int i = 0; i < pubkeyList.size(); ++i) {
                final byte[] pubkey = pubkeyList.get(i);
                Keypair keypair = new Keypair(pubkey);
                byte[] withAlgoPub = new byte[2 + keypair.getPubkeyId().length];
                System.arraycopy(keypair.getType().toBytes(), 0, withAlgoPub, 0, 2);
                System.arraycopy(keypair.getPubkeyId(), 0, withAlgoPub, 2, keypair.getPubkeyId().length);
                byte[] pubkeyFp = CryptoUtils.getPubkeyFp(withAlgoPub);
                final int finalI = i;
                Pair<byte[], Integer> pair = new Pair<byte[], Integer>(){

                    public byte[] getLeft() {
                        return pubkey;
                    }

                    public Integer getRight() {
                        return finalI;
                    }

                    public Integer setValue(Integer value) {
                        return null;
                    }
                };
                List<1> list = pubkeyMap.containsKey(ByteUtils.toHexString(pubkeyFp)) ? (List)pubkeyMap.get(ByteUtils.toHexString(pubkeyFp)) : new ArrayList<1>();
                list.add(pair);
                pubkeyMap.put(ByteUtils.toHexString(pubkeyFp), list);
            }
            block3: for (int index = 0; index < signatureList.size(); ++index) {
                byte[] pubkeyfp;
                byte[] signature = signatureList.get(index);
                if (signature.length == 65) {
                    byte[] pubkeyRecovered;
                    SignerBase signer = this.createSignerByAlgo(AlgoIdEnum.SIGNER_ECCK1_LOCAL_V0);
                    if (signer == null || (pubkeyRecovered = signer.recover(signature, msg)) == null) continue;
                    for (int i = 0; i < pubkeyList.size(); ++i) {
                        byte[] pubkey = pubkeyList.get(i);
                        if (!Arrays.equals(pubkey, pubkeyRecovered)) continue;
                        pubkeyMatchedIndex.add(i);
                        continue block3;
                    }
                    continue;
                }
                if (signature.length <= 6 || !pubkeyMap.containsKey(ByteUtils.toHexString(pubkeyfp = Arrays.copyOfRange(signature, 2, 6)))) continue;
                List list = (List)pubkeyMap.get(ByteUtils.toHexString(pubkeyfp));
                for (Pair pair : list) {
                    byte[] pubkey = (byte[])pair.getKey();
                    Keypair keypair = new Keypair(pubkey);
                    SignerBase signer = this.createSigner(AlgoIdEnum.valueOf(signature), keypair);
                    if (signer == null) continue block3;
                    try {
                        if (!signer.verify(signature, msg)) continue;
                        pubkeyMatchedIndex.add((Integer)pair.getValue());
                        continue block3;
                    }
                    catch (Exception e) {
                    }
                }
            }
        }
        return pubkeyMatchedIndex;
    }

    private SignerBase createSigner(AlgoIdEnum algoIdEnum, Keypair keypair) {
        try {
            Class signer = this.getSignerFromAlgo(algoIdEnum);
            return (SignerBase)ReflectionUtil.newInstance(signer, keypair);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private AlgoIdEnum cipher2Envelope(AlgoIdEnum algoIdEnum) {
        switch (algoIdEnum) {
            case PKEY_CIPHER_ECCK1_LOCAL_V1: {
                algoIdEnum = null;
                break;
            }
            case PKEY_CIPHER_SM2_LOCAL_V1: {
                algoIdEnum = null;
                break;
            }
            case PKEY_KDF_ECCK1_LOCAL_V1: {
                algoIdEnum = AlgoIdEnum.ENVELOPE_ECCK1_LOCAL_V1;
                break;
            }
            case PKEY_CIPHER_RSA_OAEP_LOCAL_V0: {
                algoIdEnum = AlgoIdEnum.ENVELOPE_RSA_LOCAL_SGX;
                break;
            }
            default: {
                algoIdEnum = null;
            }
        }
        return algoIdEnum;
    }

    private Class getSignerFromAlgo(AlgoIdEnum algoIdEnum) {
        switch (algoIdEnum) {
            case SIGNER_ECCK1_LOCAL_V0: {
                return EccK1KeypairV0.class;
            }
            case SIGNER_SM2_LOCAL_V1: {
                return SM2SignerV1.class;
            }
            case SIGNER_RSA_LOCAL_V1: {
                return RsaSignerV1.class;
            }
            case SIGNER_ECCR1_LOCAL_V1: {
                return EccR1SignerV1.class;
            }
        }
        return null;
    }

    private Class getCipherFromAlgo(AlgoIdEnum algoIdEnum) {
        switch (algoIdEnum) {
            case CIPHER_AES_GCM_LOCAL_V1: {
                return AesGcmCipherV1.class;
            }
        }
        return null;
    }

    private Class getPkeyCipherFromAlgo(AlgoIdEnum algoIdEnum) {
        switch (algoIdEnum) {
            case PKEY_CIPHER_RSA_OAEP_LOCAL_V0: {
                return RSAPkeyCipherV0.class;
            }
            case PKEY_KDF_ECCK1_LOCAL_V1: {
                return EccK1KDFV1.class;
            }
        }
        return null;
    }

    private Class getEnvelopeFromAlgo(AlgoIdEnum algoIdEnum) {
        switch (algoIdEnum) {
            case ENVELOPE_RSA_LOCAL_SGX: {
                return RSAEnvelopeSGX.class;
            }
            case ENVELOPE_ECCK1_LOCAL_V1: {
                return EccK1EnvelopeV1.class;
            }
            case ENVELOPE_ECCK1_LOCAL_SGX: {
                return EccK1EnvelopeSGX.class;
            }
        }
        return null;
    }
}

