/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.cipher;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.CipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesGcmCipherV1
extends CipherBase {
    public AesGcmCipherV1(byte[] key) {
        super(key);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Override
    public byte[] encrypt(byte[] plaintext) {
        try {
            SecretKeySpec skey = new SecretKeySpec(this.key, "AES");
            Cipher aesCipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            byte[] iv = new byte[this.kIvLen];
            new Random().nextBytes(iv);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(this.kTagLen * 8, iv);
            aesCipher.init(1, (Key)skey, gcmSpec);
            byte[] gcmCipherText = aesCipher.doFinal(plaintext);
            byte[] output = new byte[2 + this.kIvLen + gcmCipherText.length];
            byte[] gcmCipherTextWithouTag = Arrays.copyOfRange(gcmCipherText, 0, gcmCipherText.length - this.kTagLen);
            byte[] authtag = Arrays.copyOfRange(gcmCipherText, gcmCipherTextWithouTag.length, gcmCipherText.length);
            byte[] algoid = this.getAlgo().toBytes();
            System.arraycopy(algoid, 0, output, 0, 2);
            System.arraycopy(iv, 0, output, 2, this.kIvLen);
            System.arraycopy(authtag, 0, output, 2 + this.kIvLen, this.kTagLen);
            System.arraycopy(gcmCipherTextWithouTag, 0, output, 2 + this.kIvLen + this.kTagLen, gcmCipherTextWithouTag.length);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (BadPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IllegalBlockSizeException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        if (ciphertext == null || ciphertext.length < 2 + this.kIvLen + this.kTagLen) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text!");
        }
        if (AlgoIdEnum.valueOf(ciphertext) != this.getAlgo()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid algoid!");
        }
        byte[] iv = Arrays.copyOfRange(ciphertext, 2, 2 + this.kIvLen);
        byte[] authtag = Arrays.copyOfRange(ciphertext, 2 + this.kIvLen, 2 + this.kIvLen + this.kTagLen);
        byte[] gcmCipherTextWithouTag = Arrays.copyOfRange(ciphertext, 2 + this.kIvLen + this.kTagLen, ciphertext.length);
        byte[] aesCipherText = new byte[this.kTagLen + gcmCipherTextWithouTag.length];
        System.arraycopy(gcmCipherTextWithouTag, 0, aesCipherText, 0, gcmCipherTextWithouTag.length);
        System.arraycopy(authtag, 0, aesCipherText, gcmCipherTextWithouTag.length, this.kTagLen);
        try {
            SecretKeySpec skey = new SecretKeySpec(this.key, "AES");
            Cipher aesCipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(this.kTagLen * 8, iv);
            aesCipher.init(2, (Key)skey, gcmSpec);
            byte[] plainText = aesCipher.doFinal(aesCipherText);
            return plainText;
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (BadPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IllegalBlockSizeException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.CIPHER_AES_GCM_LOCAL_V1;
    }
}

