/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.keypair;

import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class Keypair {
    private KeyTypeEnum type;
    private byte[] privkeyId;
    private byte[] pubkeyId;

    public Keypair(byte[] pubkeyEncoded) {
        if (ArrayUtils.isEmpty((byte[])pubkeyEncoded)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkeyEncoded should not empty");
        }
        if (pubkeyEncoded.length <= 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkeyEncoded is too short");
        }
        if (pubkeyEncoded.length == 64) {
            this.pubkeyId = ArrayUtils.clone((byte[])pubkeyEncoded);
            this.type = KeyTypeEnum.KEY_ECCK1_PKCS8;
        } else {
            this.type = KeyTypeEnum.valueOf(pubkeyEncoded);
            if (this.type == KeyTypeEnum.UNKNOWN) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type");
            }
            if (!this.isvalidPubkeySize(this.type, pubkeyEncoded.length - 2)) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid pubkey size");
            }
            this.pubkeyId = Arrays.copyOfRange(pubkeyEncoded, 2, pubkeyEncoded.length);
        }
    }

    public Keypair(byte[] pubkeyEncoded, byte[] privkeyEncoded) {
        if (ArrayUtils.isEmpty((byte[])privkeyEncoded)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "privkeyEncoded should not empty");
        }
        if (privkeyEncoded.length <= 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "privkeyEncoded is too short");
        }
        if (pubkeyEncoded != null && pubkeyEncoded.length <= 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkeyEncoded is too short");
        }
        if (privkeyEncoded.length == 32) {
            this.type = KeyTypeEnum.KEY_ECCK1_PKCS8;
            this.privkeyId = ArrayUtils.clone((byte[])privkeyEncoded);
        } else {
            this.type = KeyTypeEnum.valueOf(privkeyEncoded);
            if (this.type == KeyTypeEnum.UNKNOWN) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type");
            }
            if (!this.isvalidPrikeySize(this.type, privkeyEncoded.length - 2)) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid privkey size");
            }
            this.privkeyId = Arrays.copyOfRange(privkeyEncoded, 2, privkeyEncoded.length);
        }
        if (pubkeyEncoded != null) {
            KeyTypeEnum pubkeyType = pubkeyEncoded.length == 64 ? KeyTypeEnum.KEY_ECCK1_PKCS8 : KeyTypeEnum.valueOf(pubkeyEncoded);
            if (this.type != pubkeyType) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pubkeyEncoded and privkeyEncoded types are different");
            }
            if (pubkeyEncoded.length == 64) {
                this.pubkeyId = ArrayUtils.clone((byte[])pubkeyEncoded);
            } else {
                if (!this.isvalidPubkeySize(this.type, pubkeyEncoded.length - 2)) {
                    throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid pubkey size");
                }
                this.pubkeyId = Arrays.copyOfRange(pubkeyEncoded, 2, pubkeyEncoded.length);
            }
        }
    }

    public boolean isPubkey() {
        return !ArrayUtils.isEmpty((byte[])this.pubkeyId);
    }

    public boolean isPrivkey() {
        return !ArrayUtils.isEmpty((byte[])this.privkeyId);
    }

    public KeyTypeEnum getType() {
        return this.type;
    }

    public byte[] getPrivkeyId() {
        return this.privkeyId;
    }

    public byte[] getPubkeyId() {
        if (this.pubkeyId == null) {
            return null;
        }
        if (this.type == KeyTypeEnum.KEY_ECCK1_PKCS8) {
            return Arrays.copyOfRange(this.pubkeyId, this.pubkeyId.length - 64, this.pubkeyId.length);
        }
        return this.pubkeyId;
    }

    public byte[] getPrivkeyEncoded() {
        if (this.privkeyId == null) {
            return null;
        }
        if (this.type == KeyTypeEnum.KEY_ECCK1_PKCS8) {
            return this.privkeyId;
        }
        return this.encodeKey(this.privkeyId);
    }

    public byte[] getPubkeyEncoded() {
        if (this.pubkeyId == null) {
            return null;
        }
        if (this.type == KeyTypeEnum.KEY_ECCK1_PKCS8) {
            return this.getPubkeyId();
        }
        return this.encodeKey(this.pubkeyId);
    }

    private boolean isvalidPubkeySize(KeyTypeEnum type, int size) {
        switch (type) {
            case KEY_ECCK1_PKCS8: 
            case KEY_ECCR1_PKCS8: 
            case KEY_SM2_PKCS8: {
                return size == 65;
            }
            case KEY_RSA2048_PKCS8: {
                return true;
            }
        }
        return false;
    }

    private boolean isvalidPrikeySize(KeyTypeEnum type, int size) {
        switch (type) {
            case KEY_ECCK1_PKCS8: 
            case KEY_ECCR1_PKCS8: 
            case KEY_SM2_PKCS8: {
                return size == 32;
            }
            case KEY_RSA2048_PKCS8: {
                return true;
            }
        }
        return false;
    }

    private byte[] encodeKey(byte[] key) {
        byte[] keyEncoded = new byte[2 + key.length];
        byte[] keyType = this.type.toBytes();
        System.arraycopy(keyType, 0, keyEncoded, 0, 2);
        System.arraycopy(key, 0, keyEncoded, 2, key.length);
        return keyEncoded;
    }
}

