/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.privacy;

import com.alipay.mychain.sdk.domain.privacy.CommitmentType;
import com.alipay.mychain.sdk.domain.privacy.PedersenCommitment;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class Proofs {
    private long ptr = 0L;
    private CommitmentType type = CommitmentType.COMMITMENT_INPUT;

    public Proofs() {
        this.ptr = this.nativeNewInstance();
    }

    public Proofs(long ptr) {
        this.ptr = ptr;
    }

    public static Proofs createProofs(byte[] proofs, String txHash) {
        return new Proofs(Proofs.nativeCreateProofs(proofs, txHash));
    }

    public static native long nativeCreateProofs(byte[] var0, String var1);

    public static native void destroyProofs(String var0);

    public static boolean verifyCommitment(String txHash, CommitmentType type, int index, byte[] pubkey, byte[] valueEnc) {
        return Proofs.verifyCommitment(txHash, type.getValue(), index, pubkey, valueEnc);
    }

    private static native boolean verifyCommitment(String var0, int var1, int var2, byte[] var3, byte[] var4);

    public static boolean verifyRange(String txHash, int index, long minValue) {
        return Proofs.nativeVerifyRange(txHash, index, minValue);
    }

    private static native boolean nativeVerifyRange(String var0, int var1, long var2);

    public static boolean verifyBalance(String txHash, int index) {
        return Proofs.nativeVerifyBalance(txHash, index);
    }

    private static native boolean nativeVerifyBalance(String var0, int var1);

    public static void cancelPreVerify(String txHash) {
        Proofs.nativeCancelPreVerify(txHash);
    }

    public static native void nativeCancelPreVerify(String var0);

    private static Proofs getProofs(String txHash) {
        return new Proofs(Proofs.nativeGetProofs(txHash));
    }

    private static native long nativeGetProofs(String var0);

    public void destory() {
        if (this.ptr != 0L) {
            this.destoryInstance(this.ptr);
            this.ptr = 0L;
        }
    }

    private native long nativeNewInstance();

    private native long destoryInstance(long var1);

    public boolean addCommitment(PedersenCommitment commitment) {
        return this.nativeAddCommitment(commitment.getPtr());
    }

    private native boolean nativeAddCommitment(long var1);

    public void setBlindDelta(byte[] delta) {
        this.nativeSetBlindDelta(delta);
    }

    public native void nativeSetBlindDelta(byte[] var1);

    public boolean addRangeProof(List<Long> values, long minValue, List<byte[]> blindValues, List<Integer> commitments) {
        byte[][] blindValueArray = new byte[blindValues.size()][];
        for (int i = 0; i < blindValues.size(); ++i) {
            blindValueArray[i] = blindValues.get(i);
        }
        return this.nativeAddRangeProof(ArrayUtils.toPrimitive((Long[])values.toArray(new Long[values.size()])), minValue, (byte[][])blindValueArray, ArrayUtils.toPrimitive((Integer[])commitments.toArray(new Integer[commitments.size()])));
    }

    private native boolean nativeAddRangeProof(long[] var1, long var2, byte[][] var4, int[] var5);

    public boolean addRangeProof(List<Long> values, List<Long> minValues, List<byte[]> blindValues, List<Integer> commitments) {
        byte[][] blindValueArray = new byte[blindValues.size()][];
        for (int i = 0; i < blindValues.size(); ++i) {
            blindValueArray[i] = blindValues.get(i);
        }
        return this.nativeAddRangeProof(ArrayUtils.toPrimitive((Long[])values.toArray(new Long[values.size()])), ArrayUtils.toPrimitive((Long[])minValues.toArray(new Long[minValues.size()])), (byte[][])blindValueArray, ArrayUtils.toPrimitive((Integer[])commitments.toArray(new Integer[commitments.size()])));
    }

    public native boolean nativeAddRangeProof(long[] var1, long[] var2, byte[][] var3, int[] var4);

    public boolean verifyCommitment(CommitmentType type, int index, byte[] pubkey, byte[] valueEnc) {
        return this.nativeVerifyCommitment(type.getValue(), index, pubkey, valueEnc);
    }

    public native boolean nativeVerifyCommitment(int var1, int var2, byte[] var3, byte[] var4);

    public boolean verifyBalance() {
        return this.nativeVerifyBalance();
    }

    public native boolean nativeVerifyBalance();

    public boolean verifyRange(int index, long minValue) {
        return this.nativeVerifyRange(index, minValue);
    }

    public native boolean nativeVerifyRange(int var1, long var2);

    public boolean verifyRange(int index, List<Long> minValues) {
        return this.nativeVerifyRange(index, ArrayUtils.toPrimitive((Long[])minValues.toArray(new Long[minValues.size()])));
    }

    public native boolean nativeVerifyRange(int var1, long[] var2);

    public boolean formBytes(byte[] proofs) {
        return this.nativeFormBytes(proofs);
    }

    public native boolean nativeFormBytes(byte[] var1);

    public final byte[] toBytes() {
        return this.nativeToBytes();
    }

    private native byte[] nativeToBytes();

    public long getPtr() {
        return this.ptr;
    }
}

