/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.status.ConsensusInfo;
import com.alipay.mychain.sdk.domain.status.ConsensusInfoEnum;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class PbftInfo
extends ConsensusInfo {
    private String phase;
    private long n;
    private long f;
    private Hash currentLeader;
    private Hash myId;
    private long currentView;
    private long lastExecSeq;
    private long proposeSize;
    private long proposeTimeoutInterval;
    private long normalTimeoutInterval;
    private long viewchangeTimeoutInterval;

    public static PbftInfo builder(String phase, long n, long f, Hash currentLeader, Hash myId, long currentView, long lastExecSeq, long proposeSize, long proposeTimeoutInterval, long normalTimeoutInterval, long viewchangeTimeoutInterval) {
        PbftInfo pbftInfo = new PbftInfo();
        pbftInfo.phase = phase;
        pbftInfo.n = n;
        pbftInfo.f = f;
        pbftInfo.currentLeader = currentLeader;
        pbftInfo.myId = myId;
        pbftInfo.currentView = currentView;
        pbftInfo.lastExecSeq = lastExecSeq;
        pbftInfo.proposeSize = proposeSize;
        pbftInfo.proposeTimeoutInterval = proposeTimeoutInterval;
        pbftInfo.normalTimeoutInterval = normalTimeoutInterval;
        pbftInfo.viewchangeTimeoutInterval = viewchangeTimeoutInterval;
        return pbftInfo;
    }

    public String getPhase() {
        return this.phase;
    }

    public long getN() {
        return this.n;
    }

    public long getF() {
        return this.f;
    }

    public Hash getCurrentLeader() {
        return this.currentLeader;
    }

    public Hash getMyId() {
        return this.myId;
    }

    public long getCurrentView() {
        return this.currentView;
    }

    public long getLastExecSeq() {
        return this.lastExecSeq;
    }

    public long getProposeSize() {
        return this.proposeSize;
    }

    public long getProposeTimeoutInterval() {
        return this.proposeTimeoutInterval;
    }

    public long getNormalTimeoutInterval() {
        return this.normalTimeoutInterval;
    }

    public long getViewchangeTimeoutInterval() {
        return this.viewchangeTimeoutInterval;
    }

    @Override
    public ConsensusInfoEnum getConsensusInfoEnum() {
        return ConsensusInfoEnum.CONSENSUS_INFO_TYPE_PBFT;
    }

    @Override
    public byte[] toRlp() {
        byte[] phaseBytes = Rlp.encodeString(this.phase);
        byte[] nBytes = Rlp.encodeLong(this.n);
        byte[] fBytes = Rlp.encodeLong(this.f);
        byte[] currentLeaderBytes = Rlp.encodeElement(this.currentLeader.getValue());
        byte[] myIdBytes = Rlp.encodeElement(this.myId.getValue());
        byte[] currentViewBytes = Rlp.encodeLong(this.currentView);
        byte[] lastExecSeqBytes = Rlp.encodeLong(this.lastExecSeq);
        byte[] proposeSizeBytes = Rlp.encodeLong(this.proposeSize);
        byte[] proposeTimeoutIntervalBytes = Rlp.encodeLong(this.proposeTimeoutInterval);
        byte[] normalTimeoutIntervalBytes = Rlp.encodeLong(this.normalTimeoutInterval);
        byte[] viewchangeTimeoutIntervalBytes = Rlp.encodeLong(this.viewchangeTimeoutInterval);
        return Rlp.encodeList(super.toRlp(), phaseBytes, nBytes, fBytes, currentLeaderBytes, myIdBytes, currentViewBytes, lastExecSeqBytes, proposeSizeBytes, proposeTimeoutIntervalBytes, normalTimeoutIntervalBytes, viewchangeTimeoutIntervalBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.phase = ByteUtils.byteArrayToString(((RlpElement)list.get(1)).getRlpData());
        this.n = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.f = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
        this.currentLeader = new Hash(((RlpElement)list.get(4)).getRlpData());
        this.myId = new Hash(((RlpElement)list.get(5)).getRlpData());
        this.currentView = ByteUtils.byteArrayToLong(((RlpElement)list.get(6)).getRlpData());
        this.lastExecSeq = ByteUtils.byteArrayToLong(((RlpElement)list.get(7)).getRlpData());
        this.proposeSize = ByteUtils.byteArrayToLong(((RlpElement)list.get(8)).getRlpData());
        this.proposeTimeoutInterval = ByteUtils.byteArrayToLong(((RlpElement)list.get(9)).getRlpData());
        this.normalTimeoutInterval = ByteUtils.byteArrayToLong(((RlpElement)list.get(10)).getRlpData());
        this.viewchangeTimeoutInterval = ByteUtils.byteArrayToLong(((RlpElement)list.get(11)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("phase", (Object)this.phase);
        jsonObject.put("n", (Object)this.n);
        jsonObject.put("f", (Object)this.f);
        jsonObject.put("current_leader", (Object)ByteUtils.toHexString(this.currentLeader.getValue()));
        jsonObject.put("my_id", (Object)ByteUtils.toHexString(this.myId.getValue()));
        jsonObject.put("current_view", (Object)this.currentView);
        jsonObject.put("last_exec_seq", (Object)this.lastExecSeq);
        jsonObject.put("propose_size", (Object)this.proposeSize);
        jsonObject.put("propose_timeout_interval", (Object)this.proposeTimeoutInterval);
        jsonObject.put("normal_timeout_interval", (Object)this.normalTimeoutInterval);
        jsonObject.put("viewchange_timeout_interval", (Object)this.viewchangeTimeoutInterval);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.phase = jsonObject.getString("phase");
        this.n = jsonObject.getLong("n");
        this.f = jsonObject.getLong("f");
        this.currentLeader = new Hash(jsonObject.getString("current_leader"));
        this.myId = new Hash(jsonObject.getString("my_id"));
        this.currentView = jsonObject.getLong("current_view");
        this.lastExecSeq = jsonObject.getLong("last_exec_seq");
        this.proposeSize = jsonObject.getLong("propose_size");
        this.proposeTimeoutInterval = jsonObject.getLong("propose_timeout_interval");
        this.normalTimeoutInterval = jsonObject.getLong("normal_timeout_interval");
        this.viewchangeTimeoutInterval = jsonObject.getLong("viewchange_timeout_interval");
    }
}

