/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.transaction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.bloom.BloomFilter;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.transaction.LogEntry;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

public class TransactionReceipt
extends MychainObject {
    private long result = 1L;
    private BigInteger gasUsed;
    private List<LogEntry> logs = new ArrayList<LogEntry>();
    private byte[] output;

    public TransactionReceipt(long result, BigInteger gasUsed, List<LogEntry> logs, byte[] output) {
        this.result = result;
        this.gasUsed = gasUsed;
        this.logs = logs;
        this.output = output;
    }

    public TransactionReceipt() {
    }

    public long getResult() {
        return this.result;
    }

    public void setResult(long result) {
        this.result = result;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(BigInteger gasUsed) {
        this.gasUsed = gasUsed;
    }

    public List<LogEntry> getLogs() {
        return this.logs;
    }

    public void setLogs(List<LogEntry> logs) {
        this.logs = logs;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public void setOutput(byte[] output) {
        this.output = output;
    }

    public BloomFilter generateBloom() {
        BloomFilter bloomFilter = null;
        for (LogEntry item : this.logs) {
            if (bloomFilter == null) {
                bloomFilter = new BloomFilter();
            }
            byte[] itemBytes = item.generateBloom().getBitSet().toByteArray();
            byte[] receiptBytes = bloomFilter.getBitSet().toByteArray();
            byte[] result = new byte[bloomFilter.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(itemBytes[i] | receiptBytes[i]);
            }
            BitSet bitSet = BitSet.valueOf(result);
            bloomFilter.setBitset(bitSet);
        }
        return bloomFilter;
    }

    @Override
    public byte[] toRlp() {
        byte[] resultBytes = Rlp.encodeBigInteger(BigInteger.valueOf(this.result));
        byte[] gasUsedBytes = Rlp.encodeBigInteger(this.gasUsed);
        ArrayList<byte[]> logList = new ArrayList<byte[]>();
        if (this.logs != null) {
            for (LogEntry item : this.logs) {
                logList.add(item.toRlp());
            }
        }
        byte[] logsBytes = Rlp.encodeList(logList);
        byte[] outputBytes = Rlp.encodeElement(this.output);
        return Rlp.encodeList(resultBytes, gasUsedBytes, logsBytes, outputBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.result = ByteUtils.byteArrayToLong(((RlpElement)list.get(0)).getRlpData());
        this.gasUsed = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        RlpList logList = (RlpList)list.get(2);
        for (RlpElement element : logList) {
            LogEntry item = new LogEntry();
            item.fromRlp((RlpList)element);
            this.logs.add(item);
        }
        this.output = ((RlpElement)list.get(3)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("result", (Object)this.result);
        jsonObject.put("gas_used", (Object)this.gasUsed);
        jsonObject.put("output", (Object)ByteUtils.toHexString(this.output));
        JSONArray logsArray = new JSONArray();
        if (this.logs != null) {
            for (LogEntry item : this.logs) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                logsArray.add((Object)object);
            }
        }
        jsonObject.put("logs", (Object)logsArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.result = jsonObject.getLong("result");
        this.gasUsed = jsonObject.getBigInteger("gas_used");
        this.output = ByteUtils.hexStringToBytes(jsonObject.getString("output"));
        JSONArray extArray = jsonObject.getJSONArray("logs");
        if (extArray != null) {
            Iterator iterator = extArray.iterator();
            while (iterator.hasNext()) {
                LogEntry object = new LogEntry();
                object.fromJson((JSONObject)iterator.next());
                this.logs.add(object);
            }
        }
    }
}

