/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryAccountResponse
extends Response {
    private BigInteger blockNumber = BigInteger.ZERO;
    private Account account;

    public QueryAccountResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_ACCOUNT);
    }

    public QueryAccountResponse(Account account, BigInteger blockNumber) {
        super(MessageType.MSG_TYPE_QUERY_RESP_ACCOUNT);
        this.account = account;
        this.blockNumber = blockNumber;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public byte[] toRlp() {
        byte[] accountBytes = this.account.toRlp();
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        return Rlp.encodeList(super.toRlp(), accountBytes, blockNumberBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.account = new Account();
        this.account.fromRlp((RlpList)list.get(1));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONObject object = new JSONObject();
        this.account.toJson(object);
        jsonObject.put("account", (Object)object);
        jsonObject.put("block_number", (Object)this.blockNumber);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.account = new Account();
        this.account.fromJson(jsonObject.getJSONObject("account"));
        this.blockNumber = jsonObject.getBigInteger("block_number");
    }
}

