/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty;

import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.api.env.NetworkOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.netty.BaseChannel;
import com.alipay.mychain.sdk.network.netty.HttpClientTransport;
import com.alipay.mychain.sdk.network.netty.INetEventHandler;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;

public class HttpChannel
extends BaseChannel {
    public HttpChannel(ILogger logger) {
        super(logger);
    }

    public HttpChannel init(INetEventHandler handler, NetworkOption networkOption, ISslOption sslOption) {
        HttpClientTransport transport = new HttpClientTransport(handler, networkOption, sslOption, this.logger);
        transport.initChannelHandlers();
        transport.configTransport();
        this.setTransport(transport);
        return this;
    }

    @Override
    public void sendRequest(Object obj) {
        if (!(obj instanceof byte[])) {
            return;
        }
        byte[] stream = (byte[])obj;
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.getTransport().channel().remoteAddress().toString());
        httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        httpRequest.content().clear().writeBytes(Unpooled.wrappedBuffer((byte[])stream));
        httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)httpRequest.content().readableBytes());
        super.sendRequest(httpRequest);
    }
}

