/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.envelop;

import com.alipay.mychain.zoro.crypto.AlgorithmService;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoService;
import java.security.interfaces.RSAPublicKey;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;

public class EnvelopeEnc {
    private static final int IV_AND_KEY_LENGTH = 44;

    public static AbstractMap.SimpleEntry<Vector<byte[]>, Map<RSAPublicKey, byte[]>> encrypt(Vector<byte[]> msg, Vector<RSAPublicKey> pubkeys) throws CryptoException {
        Vector commonCiphertext = new Vector();
        ConcurrentHashMap pubkeyEnvelopeMap = new ConcurrentHashMap();
        AbstractMap.SimpleEntry<Vector<byte[]>, Map<RSAPublicKey, byte[]>> retCiphers = new AbstractMap.SimpleEntry<Vector<byte[]>, Map<RSAPublicKey, byte[]>>(commonCiphertext, pubkeyEnvelopeMap);
        try {
            byte[] randomAesKey = AlgorithmService.genAES256SecretKey();
            byte[] randomIv = AlgorithmService.random(12);
            for (byte[] oneMsg : msg) {
                retCiphers.getKey().add(AlgorithmService.aes256GCM(1, randomAesKey, randomIv, oneMsg));
            }
            byte[] concatIvAndKey = ArrayUtils.addAll((byte[])randomAesKey, (byte[])randomIv);
            for (RSAPublicKey oneRsaPub : pubkeys) {
                ((Map)retCiphers.getValue()).put(oneRsaPub, AlgorithmService.rsa2048Encrypt(oneRsaPub, concatIvAndKey));
            }
            concatIvAndKey = null;
            randomAesKey = null;
            randomIv = null;
            return retCiphers;
        }
        catch (Exception e) {
            throw new CryptoException("Envelope encryption error.", e);
        }
    }

    public static Vector<byte[]> decrypt(byte[] keyname, byte[] password, byte[] envelopeKeyEncMsg, Vector<byte[]> ciphertexts) throws Exception {
        CryptoService getKeyService = CryptoService.getInstance();
        Vector<byte[]> plaintexts = new Vector<byte[]>();
        try {
            byte[] aesKeyandIv = getKeyService.rsa2048Decrypt(keyname, password, envelopeKeyEncMsg);
            if (aesKeyandIv.length != 44) {
                throw new CryptoException("Envelope decryption error: key and iv total length error.");
            }
            byte[] aesKey = Arrays.copyOfRange(aesKeyandIv, 0, 32);
            byte[] aesIv = Arrays.copyOfRange(aesKeyandIv, 32, 44);
            for (byte[] oneCiphertext : ciphertexts) {
                plaintexts.add(AlgorithmService.aes256GCM(2, aesKey, aesIv, oneCiphertext));
            }
            aesIv = null;
            aesKey = null;
            aesKeyandIv = null;
            return plaintexts;
        }
        catch (CryptoException e) {
            throw new CryptoException("aes gcm envelop decryption error. key error or tag mismatch.", e);
        }
        catch (Exception e) {
            throw new Exception("aes gcm envelop decryption error. key error or tag mismatch.", e);
        }
    }
}

