/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.eInvoice.mycrypto;

import com.alipay.mychain.eInvoice.mycrypto.LoadNativeMyCrypto;
import org.bouncycastle.crypto.digests.SHAKEDigest;

public class GenerateRandomStream {
    private static final int RANDOM_LEN = 64;
    private static final int MAX_RANDOM_LEN = 65536;

    private static byte[] shake(byte[] input, int outputLength) {
        SHAKEDigest md1 = new SHAKEDigest(256);
        byte[] digest = new byte[outputLength];
        md1.update(input, 0, input.length);
        md1.doFinal(digest, 0, outputLength);
        return digest;
    }

    public static byte[] getBytes(int length) {
        byte[] retRandomNumber = new byte[length];
        int tmpLength = length;
        do {
            byte[] generatedRN;
            byte[] seed;
            if (tmpLength <= 64) {
                seed = new byte[64];
                LoadNativeMyCrypto.nextBytes(seed);
                System.arraycopy(seed, 0, retRandomNumber, length - tmpLength, tmpLength);
                tmpLength = 0;
                continue;
            }
            if (tmpLength > 64 && tmpLength <= 65536) {
                seed = new byte[64];
                LoadNativeMyCrypto.nextBytes(seed);
                generatedRN = GenerateRandomStream.shake(seed, tmpLength);
                System.arraycopy(generatedRN, 0, retRandomNumber, length - tmpLength, tmpLength);
                tmpLength = 0;
                continue;
            }
            seed = new byte[64];
            LoadNativeMyCrypto.nextBytes(seed);
            generatedRN = GenerateRandomStream.shake(seed, 65536);
            System.arraycopy(generatedRN, 0, retRandomNumber, length - tmpLength, 65536);
            tmpLength -= 65536;
        } while (tmpLength != 0);
        return retRandomNumber;
    }
}

