/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.spv;

import com.alipay.mychain.sdk.bloom.BloomFilter;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.domain.block.BlockHeader;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;

public class LogFilter {
    private List<Hash> identities = new ArrayList<Hash>();
    private List<String> topics = new ArrayList<String>();

    public final boolean isMatch(BlockHeader header) {
        BloomFilter bloomFilter = new BloomFilter(header.getLogBloom());
        if (bloomFilter.getBitSet().length() != 0) {
            return this.isMatch(bloomFilter);
        }
        return false;
    }

    public final boolean isMatch(BloomFilter bloom) {
        for (Hash hash : this.identities) {
            if (!bloom.contains(hash.getValue())) continue;
            return true;
        }
        for (String string : this.topics) {
            if (!bloom.contains(HashFactory.getHash().hash(ByteUtils.stringToByteArray(string)))) continue;
            return true;
        }
        return false;
    }

    public final LogFilter addTopic(String topic) {
        this.topics.add(topic);
        return this;
    }

    LogFilter addIdentity(Hash id) {
        this.identities.add(id);
        return this;
    }

    public List<Hash> getIdentities() {
        return this.identities;
    }

    public List<String> getTopics() {
        return this.topics;
    }
}

