/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.codec.ICodec;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageFactory;
import com.alipay.mychain.sdk.message.MessageType;
import java.nio.charset.StandardCharsets;

public class JsonCodec
implements ICodec {
    @Override
    public byte[] encode(Message msg) {
        JSONObject object = new JSONObject();
        object.put("method", (Object)MessageFactory.msgTypeToString(msg.getMessageType()));
        JSONObject msgObject = new JSONObject();
        msg.toJson(msgObject);
        object.put("params", (Object)msgObject);
        return object.toJSONString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Message decode(byte[] data) {
        String json = new String(data, 0, data.length, StandardCharsets.UTF_8);
        JSONObject jsonObject = JSON.parseObject((String)json);
        try {
            String method = jsonObject.getString("method");
            MessageType type = MessageFactory.stringToMsgType(method);
            Message msg = (Message)MessageFactory.createMessage(type);
            if (msg == null) {
                return null;
            }
            msg.fromJson(jsonObject.getJSONObject("params"));
            return msg;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

