/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto;

import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import java.util.HashMap;
import java.util.Map;

public enum AlgoIdEnum {
    UNKNOWN(0),
    SIGNER_ECCK1_LOCAL_V0(1),
    SIGNER_ECCR1_LOCAL_V1(2),
    SIGNER_SM2_LOCAL_V1(3),
    SIGNER_RSA_LOCAL_V1(4),
    PKEY_CIPHER_RSA_OAEP_LOCAL_V0(100),
    PKEY_CIPHER_ECCK1_LOCAL_V1(101),
    PKEY_CIPHER_SM2_LOCAL_V1(102),
    PKEY_CIPHER_RSA_OAEP_LOCAL_V1(103),
    PKEY_CIPHER_ECCR1_LOCAL_V1(104),
    PKEY_KDF_ECCK1_LOCAL_V1(151),
    CIPHER_AES_GCM_LOCAL_V1(201),
    CIPHER_SM4_CBC_LOCAL_V1(202),
    CIPHER_SM4_GCM_LOCAL_V1(203),
    ENVELOPE_RSA_LOCAL_SGX(300),
    ENVELOPE_ECCK1_LOCAL_V1(301),
    ENVELOPE_RSA_LOCAL_V1(302),
    ENVELOPE_SM2_LOCAL_V1(303),
    ENVELOPE_ECCK1_LOCAL_SGX(304),
    ENVELOPE_ECCR1_LOCAL_V1(305);

    private static Map<KeyTypeEnum, AlgoIdEnum> keySignerMapping;
    private static Map<KeyTypeEnum, AlgoIdEnum> keyPkeyCipherMapping;
    private static Map<KeyTypeEnum, AlgoIdEnum> keyEnvelopeMapping;
    private int algId;

    private AlgoIdEnum(int algId) {
        this.algId = algId;
    }

    public static AlgoIdEnum valueOf(int value) {
        for (AlgoIdEnum e : AlgoIdEnum.values()) {
            if (e.algId != value) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static AlgoIdEnum valueOf(byte[] bytes) {
        if (bytes.length < 2) {
            return UNKNOWN;
        }
        int value = ((bytes[0] & 0xFF) << 8) + (bytes[1] & 0xFF);
        return AlgoIdEnum.valueOf(value);
    }

    public static AlgoIdEnum getSignerAlgoByKeyType(KeyTypeEnum kt) {
        AlgoIdEnum algoIdEnum = keySignerMapping.get((Object)kt);
        if (algoIdEnum == null) {
            return UNKNOWN;
        }
        return algoIdEnum;
    }

    public static AlgoIdEnum getPkeyCipherAlgoByKeyType(KeyTypeEnum kt) {
        AlgoIdEnum algoIdEnum = keyPkeyCipherMapping.get((Object)kt);
        if (algoIdEnum == null) {
            return UNKNOWN;
        }
        return algoIdEnum;
    }

    public static AlgoIdEnum getEnvelopeAlgoByKeyType(KeyTypeEnum kt) {
        AlgoIdEnum algoIdEnum = keyEnvelopeMapping.get((Object)kt);
        if (algoIdEnum == null) {
            return UNKNOWN;
        }
        return algoIdEnum;
    }

    public int getValue() {
        return this.algId;
    }

    public byte[] toBytes() {
        int value = this.algId;
        byte[] bytes = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return bytes;
    }

    static {
        keySignerMapping = new HashMap<KeyTypeEnum, AlgoIdEnum>();
        keyPkeyCipherMapping = new HashMap<KeyTypeEnum, AlgoIdEnum>();
        keyEnvelopeMapping = new HashMap<KeyTypeEnum, AlgoIdEnum>();
        keySignerMapping.put(KeyTypeEnum.KEY_ECCK1_PKCS8, SIGNER_ECCK1_LOCAL_V0);
        keySignerMapping.put(KeyTypeEnum.KEY_ECCR1_PKCS8, SIGNER_ECCR1_LOCAL_V1);
        keySignerMapping.put(KeyTypeEnum.KEY_SM2_PKCS8, SIGNER_SM2_LOCAL_V1);
        keySignerMapping.put(KeyTypeEnum.KEY_RSA2048_PKCS8, SIGNER_RSA_LOCAL_V1);
        keyPkeyCipherMapping.put(KeyTypeEnum.KEY_ECCK1_PKCS8, PKEY_CIPHER_ECCK1_LOCAL_V1);
        keyPkeyCipherMapping.put(KeyTypeEnum.KEY_SM2_PKCS8, PKEY_CIPHER_SM2_LOCAL_V1);
        keyPkeyCipherMapping.put(KeyTypeEnum.KEY_RSA2048_PKCS8, PKEY_CIPHER_RSA_OAEP_LOCAL_V0);
        keyEnvelopeMapping.put(KeyTypeEnum.KEY_ECCK1_PKCS8, ENVELOPE_ECCK1_LOCAL_V1);
        keyEnvelopeMapping.put(KeyTypeEnum.KEY_SM2_PKCS8, ENVELOPE_SM2_LOCAL_V1);
        keyEnvelopeMapping.put(KeyTypeEnum.KEY_RSA2048_PKCS8, ENVELOPE_RSA_LOCAL_SGX);
    }
}

