/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.consensus.honeyBadger;

import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;

public class HBSignatureInfo {
    private long view = 0L;
    private byte[] digest = null;

    public HBSignatureInfo(long view, byte[] digest) {
        this.view = view;
        this.digest = digest;
    }

    public HBSignatureInfo() {
    }

    public static HBSignatureInfo decode(RlpList list) {
        HBSignatureInfo hbSignatureInfo = new HBSignatureInfo();
        hbSignatureInfo.view = ByteUtils.byteArrayToLong(((RlpElement)list.get(0)).getRlpData());
        hbSignatureInfo.digest = ((RlpElement)list.get(1)).getRlpData();
        return hbSignatureInfo;
    }

    public static byte[] encode(HBSignatureInfo signatureInfo) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(Rlp.encodeBigInteger(BigInteger.valueOf(signatureInfo.getView())));
        data.add(Rlp.encodeElement(signatureInfo.getDigest()));
        return Rlp.encodeList(data);
    }

    public long getView() {
        return this.view;
    }

    public void setView(long view) {
        this.view = view;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }
}

