/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.transaction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.bloom.BloomFilter;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogEntry
extends MychainObject {
    private Identity from;
    private Identity to;
    private List<String> topics = new ArrayList<String>();
    private byte[] logData;

    public LogEntry(Identity from, Identity to, List<String> topics, byte[] logData) {
        this.from = from;
        this.to = to;
        this.topics = topics;
        this.logData = logData;
    }

    public LogEntry() {
    }

    public boolean matchTopic(String topic) {
        if (this.topics == null) {
            return false;
        }
        return this.topics.contains(topic);
    }

    public Identity getFrom() {
        return this.from;
    }

    public void setFrom(Identity from) {
        this.from = from;
    }

    public Identity getTo() {
        return this.to;
    }

    public void setTo(Identity to) {
        this.to = to;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public byte[] getLogData() {
        return this.logData;
    }

    public void setLogData(byte[] logData) {
        this.logData = logData;
    }

    public BloomFilter generateBloom() {
        BloomFilter bloomFilter = new BloomFilter();
        bloomFilter.add(this.from.getValue());
        bloomFilter.add(this.to.getValue());
        for (String topic : this.topics) {
            bloomFilter.add(ByteUtils.hexStringToBytes(topic));
        }
        return bloomFilter;
    }

    @Override
    public byte[] toRlp() {
        byte[] fromBytes = Rlp.encodeElement(this.from.getValue());
        byte[] toBytes = Rlp.encodeElement(this.to.getValue());
        ArrayList<byte[]> topicList = new ArrayList<byte[]>();
        if (this.topics != null) {
            for (String item : this.topics) {
                topicList.add(Rlp.encodeString(item));
            }
        }
        byte[] topicsBytes = Rlp.encodeList(topicList);
        byte[] logDataBytes = Rlp.encodeElement(this.logData);
        return Rlp.encodeList(fromBytes, toBytes, topicsBytes, logDataBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.from = new Identity(((RlpElement)list.get(0)).getRlpData());
        this.to = new Identity(((RlpElement)list.get(1)).getRlpData());
        RlpList topicList = (RlpList)list.get(2);
        for (RlpElement element : topicList) {
            this.topics.add(ByteUtils.byteArrayToString(element.getRlpData()));
        }
        this.logData = ((RlpElement)list.get(3)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("from", (Object)ByteUtils.toHexString(this.from.getValue()));
        jsonObject.put("to", (Object)ByteUtils.toHexString(this.to.getValue()));
        jsonObject.put("log_data", (Object)ByteUtils.toHexString(this.logData));
        JSONArray jsonArray = new JSONArray();
        if (this.topics != null) {
            for (String item : this.topics) {
                jsonArray.add((Object)item);
            }
        }
        jsonObject.put("topics", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.from = new Identity(jsonObject.getString("from"));
        this.to = new Identity(jsonObject.getString("to"));
        this.logData = ByteUtils.hexStringToBytes(jsonObject.getString("log_data"));
        JSONArray jsonArray = jsonObject.getJSONArray("topics");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                this.topics.add((String)iterator.next());
            }
        }
    }
}

