/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.network;

import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class ClientHandshakeResponse
extends Response {
    private Hash value;
    private long timestamp;

    public ClientHandshakeResponse() {
        super(MessageType.MSG_TYPE_HAND_SHAKE);
    }

    public ClientHandshakeResponse(Hash value, long timestamp) {
        super(MessageType.MSG_TYPE_HAND_SHAKE);
        this.value = value;
        this.timestamp = timestamp;
    }

    @Override
    public byte[] toRlp() {
        byte[] valueBytes = Rlp.encodeElement(this.value.getValue());
        byte[] timestampBytes = Rlp.encodeLong(this.timestamp);
        return Rlp.encodeList(valueBytes, timestampBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.value = new Hash(((RlpElement)((RlpList)list.get(0)).get(0)).getRlpData());
        this.timestamp = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
    }

    public Hash getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isValid() {
        return true;
    }
}

