/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

public class RelatedDepositDataRequest
extends AbstractTransactionRequest {
    private Identity senderId;
    private Identity receiverId;
    private byte[] depositData;
    private Long depositFlag;
    private BigInteger amount = BigInteger.ZERO;

    public RelatedDepositDataRequest(Identity senderId, Identity receiverId, byte[] depositData, Long depositFlag, BigInteger amount) {
        super(MessageType.MSG_TYPE_TX_REQ_RELATED_DEPOSIT_DATA);
        this.senderId = senderId;
        this.receiverId = receiverId;
        this.depositData = depositData;
        this.depositFlag = depositFlag;
        this.amount = amount;
    }

    public RelatedDepositDataRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_RELATED_DEPOSIT_DATA);
    }

    public Identity getSenderId() {
        return this.senderId;
    }

    public Identity getReceiverId() {
        return this.receiverId;
    }

    public byte[] getDepositData() {
        return this.depositData;
    }

    public long getDepositFlag() {
        return this.depositFlag;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.senderId != null && !this.senderId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.receiverId != null && !this.receiverId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.depositData != null && this.amount != null;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_RELATED_DEPOSIT_DATA);
        transaction.setFrom(this.senderId);
        transaction.setTo(this.receiverId);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.amount));
        byte[] depositFlagVal = ByteUtils.longToBytes(this.depositFlag);
        byte[] joinedArray = ArrayUtils.addAll((byte[])depositFlagVal, (byte[])this.depositData);
        transaction.setData(joinedArray);
        super.complete();
    }
}

