/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty;

import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.api.env.NetworkOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.netty.AbstractClientTransport;
import com.alipay.mychain.sdk.network.netty.ClientSslContext;
import com.alipay.mychain.sdk.network.netty.IChannelHandler;
import com.alipay.mychain.sdk.network.netty.INetEventHandler;
import com.alipay.mychain.sdk.network.netty.handler.MessageInboundHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;

public class HttpClientTransport
extends AbstractClientTransport {
    private INetEventHandler eventHandler;

    public HttpClientTransport(INetEventHandler eventHandler, NetworkOption networkOption, ISslOption sslOption, ILogger logger) {
        super(networkOption, sslOption, logger);
        this.eventHandler = eventHandler;
    }

    @Override
    protected void initChannelHandlers() {
        ClientSslContext clientSslContext = new ClientSslContext(this.sslOption, this.logger);
        final SslContext sslContext = clientSslContext.createSslContext();
        if (sslContext != null) {
            this.addChannelHandler("ssl", new IChannelHandler(){

                @Override
                public ChannelHandler getHandler(Channel channel) {
                    return sslContext.newHandler(channel.alloc());
                }
            });
        }
        this.addChannelHandler("encoder", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new HttpRequestEncoder();
            }
        });
        this.addChannelHandler("decoder", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new HttpResponseDecoder();
            }
        });
        this.addChannelHandler("chunked", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new ChunkedWriteHandler();
            }
        });
        this.addChannelHandler("aggregator", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new HttpObjectAggregator(HttpClientTransport.this.networkOption.getMaxMessageSize().intValue());
            }
        });
        if (this.networkOption.getEnableCompress().booleanValue()) {
            this.addChannelHandler("compressor", new IChannelHandler(){

                @Override
                public ChannelHandler getHandler(Channel channel) {
                    return new HttpContentCompressor();
                }
            });
        }
        this.addChannelHandler("http_msg_handler", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new MessageInboundHandler(HttpClientTransport.this.eventHandler, HttpClientTransport.this.logger);
            }
        });
    }
}

