/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.rlp;

import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpItem;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class Rlp {
    private static final double MAX_ITEM_LENGTH = Math.pow(256.0, 8.0);
    private static final int SIZE_THRESHOLD = 56;
    private static final int OFFSET_SHORT_ITEM = 128;
    private static final int OFFSET_LONG_ITEM = 183;
    private static final int OFFSET_SHORT_LIST = 192;
    private static final int OFFSET_LONG_LIST = 247;
    private static final int HEX_0XFF = 255;
    public static final byte[] EMPTY_ELEMENT_RLP = Rlp.encodeElement(new byte[0]);
    private static final int HEX_0XFFFFFF = 0xFFFFFF;
    private static final int HEX_0XFFFF = 65535;

    private static byte decodeOneByteItem(byte[] data, int index) {
        if ((data[index] & 0xFF) == 128) {
            return (byte)(data[index] - 128);
        }
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) == 129) {
            return data[index + 1];
        }
        return 0;
    }

    public static int decodeInt(byte[] data, int index) {
        int value = 0;
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) >= 128 && (data[index] & 0xFF) < 183) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value += (data[index + i] & 0xFF) << 8 * pow;
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    private static short decodeShort(byte[] data, int index) {
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            byte length = (byte)(data[index] - 128);
            return ByteBuffer.wrap(data, index, length).getShort();
        }
        return data[index];
    }

    public static long decodeLong(byte[] data, int index) {
        long value = 0L;
        if ((data[index] & 0xFF) == 128) {
            return 0L;
        }
        if ((data[index] & 0xFF) < 128) {
            return data[index];
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            int length = data[index] - 128;
            byte pow = (byte)(length - 1);
            for (int i = 1; i <= length; ++i) {
                value += (long)(data[index + i] & 0xFF) << 8 * pow;
                pow = (byte)(pow - 1);
            }
        } else {
            throw new RuntimeException("wrong decode attempt");
        }
        return value;
    }

    private static String decodeStringItem(byte[] data, int index) {
        if ((data[index] & 0xFF) >= 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            int length = Rlp.calcLength(lengthOfLength, data, index);
            return new String(data, index + lengthOfLength + 1, length);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            byte length = (byte)((data[index] & 0xFF) - 128);
            return new String(data, index + 1, (int)length);
        }
        throw new RuntimeException("wrong decode attempt");
    }

    private static byte[] decodeItemBytes(byte[] data, int index) {
        int length = Rlp.calculateLength(data, index);
        byte[] valueBytes = new byte[length];
        System.arraycopy(data, index, valueBytes, 0, length);
        return valueBytes;
    }

    public static BigInteger decodeBigInteger(byte[] data, int index) {
        int length = Rlp.calculateLength(data, index);
        if (length == 0) {
            return new BigInteger(1, new byte[]{data[index] == -128 ? (byte)0 : data[index]});
        }
        int lengthOfLength = Rlp.calculateLengthOfLength(data, index);
        byte[] valueBytes = new byte[length];
        System.arraycopy(data, index + lengthOfLength + 1, valueBytes, 0, length);
        return new BigInteger(1, valueBytes);
    }

    private static byte[] decodeByteArray(byte[] data, int index) {
        int length = Rlp.calculateLength(data, index);
        byte[] valueBytes = new byte[length];
        System.arraycopy(data, index, valueBytes, 0, length);
        return valueBytes;
    }

    private static int nextItemLength(byte[] data, int index) {
        if (index >= data.length) {
            return -1;
        }
        if ((data[index] & 0xFF) >= 247) {
            byte lengthOfLength = (byte)(data[index] - 247);
            return Rlp.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) >= 192 && (data[index] & 0xFF) < 247) {
            return (byte)((data[index] & 0xFF) - 192);
        }
        if ((data[index] & 0xFF) > 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            return Rlp.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) <= 183) {
            return (byte)((data[index] & 0xFF) - 128);
        }
        if ((data[index] & 0xFF) <= 128) {
            return 1;
        }
        return -1;
    }

    public static int getFirstListElement(byte[] payload, int pos) {
        if (pos >= payload.length) {
            return -1;
        }
        if ((payload[pos] & 0xFF) >= 247) {
            byte lengthOfLength = (byte)(payload[pos] - 247);
            return pos + lengthOfLength + 1;
        }
        if ((payload[pos] & 0xFF) >= 192 && (payload[pos] & 0xFF) < 247) {
            return pos + 1;
        }
        if ((payload[pos] & 0xFF) >= 183 && (payload[pos] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(payload[pos] - 183);
            return pos + lengthOfLength + 1;
        }
        return -1;
    }

    public static int getNextElementIndex(byte[] payload, int pos) {
        if (pos >= payload.length) {
            return -1;
        }
        if ((payload[pos] & 0xFF) >= 247) {
            byte lengthOfLength = (byte)(payload[pos] - 247);
            int length = Rlp.calcLength(lengthOfLength, payload, pos);
            return pos + lengthOfLength + length + 1;
        }
        if ((payload[pos] & 0xFF) >= 192 && (payload[pos] & 0xFF) < 247) {
            byte length = (byte)((payload[pos] & 0xFF) - 192);
            return pos + 1 + length;
        }
        if ((payload[pos] & 0xFF) >= 183 && (payload[pos] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(payload[pos] - 183);
            int length = Rlp.calcLength(lengthOfLength, payload, pos);
            return pos + lengthOfLength + length + 1;
        }
        if ((payload[pos] & 0xFF) > 128 && (payload[pos] & 0xFF) < 183) {
            byte length = (byte)((payload[pos] & 0xFF) - 128);
            return pos + 1 + length;
        }
        if ((payload[pos] & 0xFF) == 128) {
            return pos + 1;
        }
        if ((payload[pos] & 0xFF) < 128) {
            return pos + 1;
        }
        return -1;
    }

    public static void fullTraverse(byte[] msgData, int level, int startPos, int endPos, int levelToIndex, Queue<Integer> index) {
        try {
            if (msgData == null || msgData.length == 0) {
                return;
            }
            int pos = startPos;
            while (pos < endPos) {
                byte length;
                int length2;
                byte lengthOfLength;
                if (level == levelToIndex) {
                    index.add(pos);
                }
                if ((msgData[pos] & 0xFF) >= 247) {
                    lengthOfLength = (byte)(msgData[pos] - 247);
                    length2 = Rlp.calcLength(lengthOfLength, msgData, pos);
                    Rlp.fullTraverse(msgData, level + 1, pos + lengthOfLength + 1, pos + lengthOfLength + length2, levelToIndex, index);
                    pos += lengthOfLength + length2 + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 192 && (msgData[pos] & 0xFF) < 247) {
                    length = (byte)((msgData[pos] & 0xFF) - 192);
                    Rlp.fullTraverse(msgData, level + 1, pos + 1, pos + length + 1, levelToIndex, index);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 183 && (msgData[pos] & 0xFF) < 192) {
                    lengthOfLength = (byte)(msgData[pos] - 183);
                    length2 = Rlp.calcLength(lengthOfLength, msgData, pos);
                    pos += lengthOfLength + length2 + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 128 && (msgData[pos] & 0xFF) < 183) {
                    length = (byte)((msgData[pos] & 0xFF) - 128);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) == 128) {
                    ++pos;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 128) continue;
                ++pos;
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("RLP wrong encoding", th.fillInStackTrace());
        }
    }

    private static int calcLength(int lengthOfLength, byte[] msgData, int pos) {
        byte pow = (byte)(lengthOfLength - 1);
        int length = 0;
        for (int i = 1; i <= lengthOfLength; ++i) {
            int bt = msgData[pos + i] & 0xFF;
            int shift = 8 * pow;
            if (bt == 0 && length == 0) {
                throw new RuntimeException("RLP length contains leading zeros");
            }
            if (32 - Integer.numberOfLeadingZeros(bt) + shift > 31) {
                return Integer.MAX_VALUE;
            }
            length += bt << shift;
            pow = (byte)(pow - 1);
        }
        return length;
    }

    public static byte getCommandCode(byte[] data) {
        int index = Rlp.getFirstListElement(data, 0);
        byte command = data[index];
        return (command & 0xFF) == 128 ? (byte)0 : command;
    }

    public static RlpList decode2(byte[] msgData) {
        RlpList rlpList = new RlpList();
        Rlp.fullTraverse(msgData, 0, 0, msgData.length, -1, rlpList);
        return rlpList;
    }

    public static RlpList decodeResponse(byte[] msgData) {
        RlpList rlpList = new RlpList();
        Rlp.fullTraverse(msgData, 0, 0, msgData.length, 3, rlpList);
        return rlpList;
    }

    public static RlpList decodeMessage(byte[] msgData) {
        RlpList rlpList = new RlpList();
        Rlp.fullTraverse(msgData, 0, 0, msgData.length, 2, rlpList);
        return rlpList;
    }

    public static RlpElement decode2OneItem(byte[] msgData, int startPos) {
        RlpList rlpList = new RlpList();
        Rlp.fullTraverse(msgData, 0, startPos, startPos + 1, -1, rlpList);
        return (RlpElement)rlpList.get(0);
    }

    private static void fullTraverse(byte[] msgData, int level, int startPos, int endPos, int levelToIndex, RlpList rlpList) {
        try {
            if (msgData == null || msgData.length == 0) {
                return;
            }
            int pos = startPos;
            while (pos < endPos) {
                if ((msgData[pos] & 0xFF) > 247) {
                    byte lengthOfLength = (byte)(msgData[pos] - 247);
                    int length = Rlp.calcLength(lengthOfLength, msgData, pos);
                    if (length < 56) {
                        throw new RuntimeException("Short list has been encoded as long list");
                    }
                    if (length > msgData.length - pos - lengthOfLength) {
                        throw new RuntimeException("Parsed data lays outside of RLP length boundaries");
                    }
                    byte[] rlpData = new byte[lengthOfLength + length + 1];
                    System.arraycopy(msgData, pos, rlpData, 0, lengthOfLength + length + 1);
                    RlpList newLevelList = new RlpList();
                    newLevelList.setRlpData(rlpData);
                    if (levelToIndex > 0 && level < levelToIndex) {
                        Rlp.fullTraverse(msgData, level + 1, pos + lengthOfLength + 1, pos + lengthOfLength + length + 1, levelToIndex, newLevelList);
                    }
                    if (levelToIndex < 0) {
                        Rlp.fullTraverse(msgData, level + 1, pos + lengthOfLength + 1, pos + lengthOfLength + length + 1, levelToIndex, newLevelList);
                    }
                    rlpList.add(newLevelList);
                    pos += lengthOfLength + length + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 192 && (msgData[pos] & 0xFF) <= 247) {
                    byte length = (byte)((msgData[pos] & 0xFF) - 192);
                    byte[] rlpData = new byte[length + 1];
                    System.arraycopy(msgData, pos, rlpData, 0, length + 1);
                    RlpList newLevelList = new RlpList();
                    newLevelList.setRlpData(rlpData);
                    if (length > 0) {
                        if (levelToIndex > 0 && level < levelToIndex) {
                            Rlp.fullTraverse(msgData, level + 1, pos + 1, pos + length + 1, levelToIndex, newLevelList);
                        }
                        if (levelToIndex < 0) {
                            Rlp.fullTraverse(msgData, level + 1, pos + 1, pos + length + 1, levelToIndex, newLevelList);
                        }
                    }
                    rlpList.add(newLevelList);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 183 && (msgData[pos] & 0xFF) < 192) {
                    byte lengthOfLength = (byte)(msgData[pos] - 183);
                    int length = Rlp.calcLength(lengthOfLength, msgData, pos);
                    if (length < 56) {
                        throw new RuntimeException("Short item has been encoded as long item");
                    }
                    if (length > msgData.length - pos - lengthOfLength) {
                        throw new RuntimeException("Parsed data lays outside of RLP length boundaries");
                    }
                    byte[] item = new byte[length];
                    System.arraycopy(msgData, pos + lengthOfLength + 1, item, 0, length);
                    byte[] rlpPrefix = new byte[lengthOfLength + 1];
                    System.arraycopy(msgData, pos, rlpPrefix, 0, lengthOfLength + 1);
                    RlpItem rlpItem = new RlpItem(item);
                    rlpList.add(rlpItem);
                    pos += lengthOfLength + length + 1;
                    continue;
                }
                if ((msgData[pos] & 0xFF) > 128 && (msgData[pos] & 0xFF) <= 183) {
                    byte length = (byte)((msgData[pos] & 0xFF) - 128);
                    byte[] item = new byte[length];
                    System.arraycopy(msgData, pos + 1, item, 0, length);
                    if (length == 1 && (item[0] & 0xFF) < 128) {
                        throw new RuntimeException("Single byte has been encoded as byte string");
                    }
                    byte[] rlpPrefix = new byte[2];
                    System.arraycopy(msgData, pos, rlpPrefix, 0, 2);
                    RlpItem rlpItem = new RlpItem(item);
                    rlpList.add(rlpItem);
                    pos += 1 + length;
                    continue;
                }
                if ((msgData[pos] & 0xFF) == 128) {
                    byte[] item = ByteUtils.EMPTY_BYTE_ARRAY;
                    RlpItem rlpItem = new RlpItem(item);
                    rlpList.add(rlpItem);
                    ++pos;
                    continue;
                }
                if ((msgData[pos] & 0xFF) >= 128) continue;
                byte[] item = new byte[]{(byte)(msgData[pos] & 0xFF)};
                RlpItem rlpItem = new RlpItem(item);
                rlpList.add(rlpItem);
                ++pos;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("RLP wrong encoding (" + Hex.toHexString((byte[])msgData, (int)startPos, (int)(endPos - startPos)) + ")", e);
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Invalid RLP (excessive mem allocation while parsing) (" + Hex.toHexString((byte[])msgData, (int)startPos, (int)(endPos - startPos)) + ")", e);
        }
    }

    public static LList decodeLazyList(byte[] data) {
        return Rlp.decodeLazyList(data, 0, data.length).getList(0);
    }

    public static LList decodeLazyList(byte[] data, int pos, int length) {
        if (data == null || data.length < 1) {
            return null;
        }
        LList ret = new LList(data);
        int end = pos + length;
        while (pos < end) {
            int lenlen;
            int len;
            int prefix = data[pos] & 0xFF;
            if (prefix == 128) {
                ret.add(pos, 0, false);
                ++pos;
                continue;
            }
            if (prefix < 128) {
                ret.add(pos, 1, false);
                ++pos;
                continue;
            }
            if (prefix <= 183) {
                len = prefix - 128;
                ret.add(pos + 1, len, false);
                pos += len + 1;
                continue;
            }
            if (prefix < 192) {
                lenlen = prefix - 183;
                int lenbytes = ByteUtils.byteArrayToInt(Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
                ret.add(pos + 1 + lenlen, lenbytes, false);
                pos += 1 + lenlen + lenbytes;
                continue;
            }
            if (prefix <= 247) {
                len = prefix - 192;
                ret.add(pos + 1, len, true);
                pos += 1 + len;
                continue;
            }
            if (prefix <= 255) {
                lenlen = prefix - 247;
                int lenlist = ByteUtils.byteArrayToInt(Arrays.copyOfRange(data, pos + 1, pos + 1 + lenlen));
                ret.add(pos + 1 + lenlen, lenlist, true);
                pos += 1 + lenlen + lenlist;
                continue;
            }
            throw new RuntimeException("Only byte values between 0x00 and HEX_0XFF are supported, but got: " + prefix);
        }
        return ret;
    }

    public static byte[] encodeLength(int length, int offset) {
        if (length < 56) {
            byte firstByte = (byte)(length + offset);
            return new byte[]{firstByte};
        }
        if ((double)length < MAX_ITEM_LENGTH) {
            byte[] binaryLength = length > 255 ? ByteUtils.intToBytesNoLeadZeroes(length) : new byte[]{(byte)length};
            byte firstByte = (byte)(binaryLength.length + offset + 56 - 1);
            return org.bouncycastle.pqc.math.linearalgebra.ByteUtils.concatenate((byte[])new byte[]{firstByte}, (byte[])binaryLength);
        }
        throw new RuntimeException("Input too long");
    }

    public static byte[] encodeByte(byte singleByte) {
        int length = 127;
        if ((singleByte & 0xFF) == 0) {
            return new byte[]{-128};
        }
        if ((singleByte & 0xFF) <= length) {
            return new byte[]{singleByte};
        }
        return new byte[]{-127, singleByte};
    }

    public static byte[] encodeShort(short singleShort) {
        if ((singleShort & 0xFF) == singleShort) {
            return Rlp.encodeByte((byte)singleShort);
        }
        return new byte[]{-126, (byte)(singleShort >> 8 & 0xFF), (byte)(singleShort >> 0 & 0xFF)};
    }

    public static byte[] encodeInt(int singleInt) {
        if ((singleInt & 0xFF) == singleInt) {
            return Rlp.encodeByte((byte)singleInt);
        }
        if ((singleInt & 0xFFFF) == singleInt) {
            return Rlp.encodeShort((short)singleInt);
        }
        if ((singleInt & 0xFFFFFF) == singleInt) {
            return new byte[]{-125, (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
        }
        return new byte[]{-124, (byte)(singleInt >>> 24), (byte)(singleInt >>> 16), (byte)(singleInt >>> 8), (byte)singleInt};
    }

    public static byte[] encodeLong(long singleLong) {
        int i;
        for (i = 7; i >= 0 && (byte)(singleLong >>> i * 8) == 0; --i) {
        }
        if (++i <= 1) {
            return Rlp.encodeByte((byte)singleLong);
        }
        byte[] result = new byte[i + 1];
        result[0] = (byte)(128 + i);
        for (int j = 0; j < i; ++j) {
            result[i - j] = (byte)(singleLong >>> j * 8);
        }
        return result;
    }

    public static byte[] encodeString(String srcString) {
        return Rlp.encodeElement(srcString.getBytes());
    }

    public static byte[] encodeBigInteger(BigInteger srcBigInteger) {
        if (srcBigInteger.equals(BigInteger.ZERO)) {
            return Rlp.encodeByte((byte)0);
        }
        return Rlp.encodeElement(BigIntegers.asUnsignedByteArray((BigInteger)srcBigInteger));
    }

    public static byte[] encodeElement(byte[] srcData) {
        if (ByteUtils.isNullOrZeroArray(srcData)) {
            return new byte[]{-128};
        }
        if (ByteUtils.isSingleZero(srcData)) {
            return srcData;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return srcData;
        }
        if (srcData.length < 56) {
            byte length = (byte)(128 + srcData.length);
            byte[] data = Arrays.copyOf(srcData, srcData.length + 1);
            System.arraycopy(data, 0, data, 1, srcData.length);
            data[0] = length;
            return data;
        }
        int byteNum = 0;
        for (int tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        byte[] lenBytes = new byte[byteNum];
        for (int i = 0; i < byteNum; ++i) {
            lenBytes[byteNum - 1 - i] = (byte)(srcData.length >> 8 * i & 0xFF);
        }
        byte[] data = Arrays.copyOf(srcData, srcData.length + 1 + byteNum);
        System.arraycopy(data, 0, data, 1 + byteNum, srcData.length);
        data[0] = (byte)(183 + byteNum);
        System.arraycopy(lenBytes, 0, data, 1, lenBytes.length);
        return data;
    }

    public static int calcElementPrefixSize(byte[] srcData) {
        if (ByteUtils.isNullOrZeroArray(srcData)) {
            return 0;
        }
        if (ByteUtils.isSingleZero(srcData)) {
            return 0;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return 0;
        }
        if (srcData.length < 56) {
            return 1;
        }
        int byteNum = 0;
        for (int tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        return 1 + byteNum;
    }

    public static byte[] encodeListHeader(int size) {
        byte[] header;
        if (size == 0) {
            return new byte[]{-64};
        }
        int totalLength = size;
        if (totalLength < 56) {
            header = new byte[]{(byte)(192 + totalLength)};
        } else {
            int tmpLength;
            int byteNum = 0;
            for (tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            tmpLength = totalLength;
            byte[] lenBytes = new byte[byteNum];
            for (int i = 0; i < byteNum; ++i) {
                lenBytes[byteNum - 1 - i] = (byte)(tmpLength >> 8 * i & 0xFF);
            }
            header = new byte[1 + lenBytes.length];
            header[0] = (byte)(247 + byteNum);
            System.arraycopy(lenBytes, 0, header, 1, lenBytes.length);
        }
        return header;
    }

    public static byte[] encodeLongElementHeader(int length) {
        if (length < 56) {
            if (length == 0) {
                return new byte[]{-128};
            }
            return new byte[]{(byte)(128 + length)};
        }
        int byteNum = 0;
        for (int tmpLength = length; tmpLength != 0; tmpLength >>= 8) {
            byteNum = (byte)(byteNum + 1);
        }
        byte[] lenBytes = new byte[byteNum];
        for (int i = 0; i < byteNum; ++i) {
            lenBytes[byteNum - 1 - i] = (byte)(length >> 8 * i & 0xFF);
        }
        byte[] header = new byte[1 + lenBytes.length];
        header[0] = (byte)(183 + byteNum);
        System.arraycopy(lenBytes, 0, header, 1, lenBytes.length);
        return header;
    }

    public static byte[] encodeList(List<byte[]> elements) {
        int copyPos;
        byte[] data;
        if (elements == null) {
            return new byte[]{-64};
        }
        int totalLength = 0;
        for (byte[] element1 : elements) {
            totalLength += element1.length;
        }
        if (totalLength < 56) {
            data = new byte[1 + totalLength];
            data[0] = (byte)(192 + totalLength);
            copyPos = 1;
        } else {
            int tmpLength;
            int byteNum = 0;
            for (tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            tmpLength = totalLength;
            byte[] lenBytes = new byte[byteNum];
            for (int i = 0; i < byteNum; ++i) {
                lenBytes[byteNum - 1 - i] = (byte)(tmpLength >> 8 * i & 0xFF);
            }
            data = new byte[1 + lenBytes.length + totalLength];
            data[0] = (byte)(247 + byteNum);
            System.arraycopy(lenBytes, 0, data, 1, lenBytes.length);
            copyPos = lenBytes.length + 1;
        }
        for (byte[] element : elements) {
            System.arraycopy(element, 0, data, copyPos, element.length);
            copyPos += element.length;
        }
        return data;
    }

    public static byte[] encodeList(byte[] ... elements) {
        int copyPos;
        byte[] data;
        if (elements == null) {
            return new byte[]{-64};
        }
        int totalLength = 0;
        for (byte[] element1 : elements) {
            totalLength += element1.length;
        }
        if (totalLength < 56) {
            data = new byte[1 + totalLength];
            data[0] = (byte)(192 + totalLength);
            copyPos = 1;
        } else {
            int tmpLength;
            int byteNum = 0;
            for (tmpLength = totalLength; tmpLength != 0; tmpLength >>= 8) {
                byteNum = (byte)(byteNum + 1);
            }
            tmpLength = totalLength;
            byte[] lenBytes = new byte[byteNum];
            for (int i = 0; i < byteNum; ++i) {
                lenBytes[byteNum - 1 - i] = (byte)(tmpLength >> 8 * i & 0xFF);
            }
            data = new byte[1 + lenBytes.length + totalLength];
            data[0] = (byte)(247 + byteNum);
            System.arraycopy(lenBytes, 0, data, 1, lenBytes.length);
            copyPos = lenBytes.length + 1;
        }
        for (byte[] element : elements) {
            System.arraycopy(element, 0, data, copyPos, element.length);
            copyPos += element.length;
        }
        return data;
    }

    private static byte[] toBytes(Object input) {
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof String) {
            String inputString = (String)input;
            return inputString.getBytes();
        }
        if (input instanceof Long) {
            Long inputLong = (Long)input;
            return inputLong == 0L ? ByteUtils.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray((BigInteger)BigInteger.valueOf(inputLong));
        }
        if (input instanceof Integer) {
            Integer inputInt = (Integer)input;
            return inputInt == 0 ? ByteUtils.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray((BigInteger)BigInteger.valueOf(inputInt.intValue()));
        }
        if (input instanceof BigInteger) {
            BigInteger inputBigInt = (BigInteger)input;
            return inputBigInt.equals(BigInteger.ZERO) ? ByteUtils.EMPTY_BYTE_ARRAY : BigIntegers.asUnsignedByteArray((BigInteger)inputBigInt);
        }
        throw new RuntimeException("Unsupported type: Only accepting String, Integer and BigInteger for now");
    }

    private static int calculateLength(byte[] data, int index) {
        if ((data[index] & 0xFF) <= 128) {
            return 0;
        }
        if ((data[index] & 0xFF) >= 183 && (data[index] & 0xFF) < 192) {
            byte lengthOfLength = (byte)(data[index] - 183);
            return Rlp.calcLength(lengthOfLength, data, index);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            return (byte)(data[index] - 128);
        }
        throw new RuntimeException("wrong decode attempt");
    }

    private static int calculateLengthOfLength(byte[] data, int index) {
        if ((data[index] & 0xFF) <= 128) {
            return 0;
        }
        if ((data[index] & 0xFF) >= 183 && (data[index] & 0xFF) < 192) {
            return (byte)(data[index] - 183);
        }
        if ((data[index] & 0xFF) > 128 && (data[index] & 0xFF) < 183) {
            return 0;
        }
        throw new RuntimeException("wrong decode attempt");
    }

    public static final class LList {
        private final byte[] rlp;
        private final int[] offsets = new int[32];
        private final int[] lens = new int[32];
        private int cnt;

        public LList(byte[] rlp) {
            this.rlp = rlp;
        }

        public byte[] getEncoded() {
            byte[][] encoded = new byte[this.cnt][];
            for (int i = 0; i < this.cnt; ++i) {
                encoded[i] = Rlp.encodeElement(this.getBytes(i));
            }
            return Rlp.encodeList(encoded);
        }

        public void add(int off, int len, boolean isList) {
            this.offsets[this.cnt] = off;
            this.lens[this.cnt] = isList ? -1 - len : len;
            ++this.cnt;
        }

        public byte[] getBytes(int idx) {
            int len = this.lens[idx];
            len = len < 0 ? -len - 1 : len;
            byte[] ret = new byte[len];
            System.arraycopy(this.rlp, this.offsets[idx], ret, 0, len);
            return ret;
        }

        public LList getList(int idx) {
            return Rlp.decodeLazyList(this.rlp, this.offsets[idx], -this.lens[idx] - 1);
        }

        public boolean isList(int idx) {
            return this.lens[idx] < 0;
        }

        public int size() {
            return this.cnt;
        }
    }
}

