/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.type;

import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class BaseFixedSizeUnsignedInteger {
    protected BigInteger value;

    protected abstract int getBitSize();

    public BigInteger getValue() {
        return this.value;
    }

    protected void checkValid(BigInteger value) {
        if (value.compareTo(BigInteger.ZERO) < 0 || value.compareTo(this.getMaxValue()) > 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, String.format("value{%d} is not in (0-%d)", value, this.getMaxValue()));
        }
    }

    public BigInteger getMaxValue() {
        return new BigDecimal(Math.pow(2.0, this.getBitSize())).toBigInteger().subtract(BigInteger.ONE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BaseFixedSizeUnsignedInteger{");
        sb.append("value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public static class Fixed64BitUnsignedInteger
    extends BaseFixedSizeUnsignedInteger {
        public static Fixed64BitUnsignedInteger ZERO = Fixed64BitUnsignedInteger.valueOf(0L);

        public static Fixed64BitUnsignedInteger valueOf(byte[] value) {
            return Fixed64BitUnsignedInteger.valueOf(new BigInteger(1, value));
        }

        public static Fixed64BitUnsignedInteger valueOf(long value) {
            return Fixed64BitUnsignedInteger.valueOf(BigInteger.valueOf(value));
        }

        public static Fixed64BitUnsignedInteger valueOf(BigInteger value) {
            Fixed64BitUnsignedInteger fixed64BitUnsignedInteger = new Fixed64BitUnsignedInteger();
            fixed64BitUnsignedInteger.checkValid(value);
            fixed64BitUnsignedInteger.value = value;
            return fixed64BitUnsignedInteger;
        }

        @Override
        protected int getBitSize() {
            return 64;
        }
    }

    public static class Fixed32BitUnsignedInteger
    extends BaseFixedSizeUnsignedInteger {
        public static Fixed32BitUnsignedInteger ZERO = Fixed32BitUnsignedInteger.valueOf(0L);

        public static Fixed32BitUnsignedInteger valueOf(byte[] value) {
            return Fixed32BitUnsignedInteger.valueOf(new BigInteger(1, value));
        }

        public static Fixed32BitUnsignedInteger valueOf(long value) {
            return Fixed32BitUnsignedInteger.valueOf(BigInteger.valueOf(value));
        }

        public static Fixed32BitUnsignedInteger valueOf(BigInteger value) {
            Fixed32BitUnsignedInteger fixed32BitUnsignedInteger = new Fixed32BitUnsignedInteger();
            fixed32BitUnsignedInteger.checkValid(value);
            fixed32BitUnsignedInteger.value = value;
            return fixed32BitUnsignedInteger;
        }

        @Override
        protected int getBitSize() {
            return 32;
        }
    }
}

