/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractNumericType;
import java.math.BigInteger;

public abstract class AbstractFixedPointType
extends AbstractNumericType {
    static final int DEFAULT_BIT_LENGTH = 128;

    public AbstractFixedPointType(String typePrefix, int mBitSize, int nBitSize, BigInteger value) {
        super(typePrefix + mBitSize + "x" + nBitSize, value, nBitSize);
        if (!this.valid(mBitSize, nBitSize, value)) {
            throw new UnsupportedOperationException("Bitsize must be 8 bit aligned, and in range 0 < bitSize <= 256");
        }
    }

    static boolean isValidBitSize(int mBitSize, int nBitSize) {
        int bitSize = mBitSize + nBitSize;
        return mBitSize % 8 == 0 && nBitSize % 8 == 0 && bitSize > 0 && bitSize <= 256;
    }

    private static boolean isValidBitCount(int mBitSize, int nBitSize, BigInteger value) {
        return value.bitCount() <= mBitSize + nBitSize;
    }

    static BigInteger convert(BigInteger m, BigInteger n) {
        return AbstractFixedPointType.convert(128, 128, m, n);
    }

    static BigInteger convert(int mBitSize, int nBitSize, BigInteger m, BigInteger n) {
        BigInteger mPadded = m.shiftLeft(nBitSize);
        int nBitLength = n.bitLength();
        int shift = nBitLength + 3 & 0xFFFFFFFC;
        return mPadded.or(n.shiftLeft(nBitSize - shift));
    }

    boolean valid(int mBitSize, int nBitSize, BigInteger value) {
        return AbstractFixedPointType.isValidBitSize(mBitSize, nBitSize) && AbstractFixedPointType.isValidBitCount(mBitSize, nBitSize, value);
    }
}

