/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro;

import com.alipay.mychain.zoro.annotation.privacy.CommitmentChecker;
import com.alipay.mychain.zoro.annotation.privacy.Decryptor;
import com.alipay.mychain.zoro.annotation.privacy.EncryptedTuple;
import com.alipay.mychain.zoro.annotation.privacy.Node;
import com.alipay.mychain.zoro.annotation.privacy.Note;
import com.alipay.mychain.zoro.annotation.privacy.ObjectTreeBuilder;
import com.alipay.mychain.zoro.annotation.privacy.ObjectTreeHandler;
import com.alipay.mychain.zoro.annotation.privacy.PlainTuple;
import com.alipay.mychain.zoro.annotation.privacy.Verification;
import com.alipay.mychain.zoro.annotation.privacy.Writer;
import com.alipay.mychain.zoro.crypto.AlgorithmService;
import com.alipay.mychain.zoro.crypto.BulletProof;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoContext;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoService;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoServiceSpi;
import com.alipay.mychain.zoro.crypto.keymanagement.KeyManagementSpi;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.exception.ZoroException;
import com.alipay.mychain.zoro.util.Base64Codec;
import io.netty.util.internal.NativeLibraryLoader;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoroAPI {
    private static final Logger logger = LoggerFactory.getLogger(ZoroAPI.class);

    private static void checkKeyManagementSpi() throws ZoroException {
        if (null == CryptoContext.getCryptoServiceSpi() && null == CryptoContext.getKeyManagementSpi()) {
            throw new ZoroException(ZoroErrorCodeEnum.UNKNOWN_CRYPTO_EXCEPTION, "Key Management Spi is null!");
        }
    }

    public static void initZoroKeyManagementSpi(KeyManagementSpi keyManagementSpi) throws ZoroException {
        try {
            CryptoContext.setKeyManagementSpi(keyManagementSpi);
        }
        catch (Exception e) {
            throw new ZoroException(ZoroErrorCodeEnum.UNKNOWN_CRYPTO_EXCEPTION, "Key Management Spi must be initialized only once!");
        }
    }

    public static void initZoroCryptoSpi(CryptoServiceSpi cryptoServiceSpi) throws ZoroException {
        try {
            CryptoContext.setCryptoServiceSpi(cryptoServiceSpi);
        }
        catch (Exception e) {
            throw new ZoroException(ZoroErrorCodeEnum.UNKNOWN_CRYPTO_EXCEPTION, "Crypto Service Spi must be initialized only once!");
        }
    }

    public static String generateBlindFactor() throws ZoroException {
        try {
            byte[] blindFactor = BulletProof.generateBlindFactor();
            return Base64Codec.encode(blindFactor);
        }
        catch (Exception ex) {
            throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_GENERATION_FAILED, "Failed to generate blind factor!");
        }
    }

    public static <T> T mapPlainToPrivacy(Object obj, Class<T> clazz) throws ZoroException {
        if (null == obj || null == clazz) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        Node rootOfObjectTree = ObjectTreeBuilder.buildObjectTree(obj);
        ObjectTreeHandler.processRootNode(rootOfObjectTree);
        T result = Writer.writeAsDesignatedObject(rootOfObjectTree, clazz);
        return result;
    }

    public static String mapPlainToPrivacy(Object obj) throws ZoroException {
        if (null == obj) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        Node rootOfObjectTree = ObjectTreeBuilder.buildObjectTree(obj);
        ObjectTreeHandler.processRootNode(rootOfObjectTree);
        String result = Writer.writeAsString(rootOfObjectTree);
        return result;
    }

    public static <T> T mapPlainToPrivacyIndirectly(Object obj, Class<T> clazz) throws ZoroException {
        if (null == obj || null == clazz) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        Node rootOfObjectTree = ObjectTreeBuilder.buildObjectTree(obj);
        ObjectTreeHandler.processRootNode(rootOfObjectTree);
        T result = Writer.writeAsDesignatedObjectIndirectly(rootOfObjectTree, clazz);
        return result;
    }

    public static <T> T mapPrivacyToPlain(Object obj, Class<T> clazz, String selfId, byte[] keyName, byte[] password) throws ZoroException {
        if (null == obj || null == clazz || selfId == null || keyName == null || password == null) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        Node rootOfObjectTree = ObjectTreeBuilder.buildObjectTree(obj);
        Decryptor.decrypt(rootOfObjectTree, selfId, keyName, password);
        T result = Writer.writeAsDesignatedObject(rootOfObjectTree, clazz);
        return result;
    }

    public static String decrypt(String ciphertext, String envelop, byte[] keyName, byte[] password) throws ZoroException {
        if (null == ciphertext || null == envelop || null == keyName || null == password) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        return Decryptor.decrypt(ciphertext, envelop, keyName, password);
    }

    public static List<String> decrypt(List<String> ciphertextList, String envelop, byte[] keyName, byte[] password) throws ZoroException {
        if (null == ciphertextList || null == envelop || null == keyName || null == password) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        return Decryptor.decrypt(ciphertextList, envelop, keyName, password);
    }

    public static List<Note> decryptAndVerifyCommitment(List<String> commitmentList, List<String> encryptedValueList, List<String> encryptedBlindFactorList, String envelop, byte[] keyName, byte[] password) throws ZoroException {
        if (null == commitmentList || null == encryptedValueList || null == encryptedBlindFactorList || null == envelop || null == keyName || null == password) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        int commitmentListLength = commitmentList.size();
        int encryptedValueListLength = encryptedValueList.size();
        int encryptedBlindFactorListLength = encryptedBlindFactorList.size();
        if (commitmentListLength != encryptedValueListLength || commitmentListLength != encryptedBlindFactorListLength) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter list size should be equal");
        }
        ArrayList<String> ciphertextList = new ArrayList<String>(encryptedValueList);
        ciphertextList.addAll(encryptedBlindFactorList);
        List<String> plaintextList = Decryptor.decrypt(ciphertextList, envelop, keyName, password);
        ArrayList<Note> noteList = new ArrayList<Note>();
        for (int i = 0; i < commitmentListLength; ++i) {
            Note note = CommitmentChecker.checkCommitment(commitmentList.get(i), plaintextList.get(i), plaintextList.get(i + commitmentListLength), encryptedValueList.get(i), encryptedBlindFactorList.get(i));
            noteList.add(note);
        }
        return noteList;
    }

    public static Note decryptAndVerifyCommitment(String commitment, String encryptedValue, String encryptedBlindFactor, String envelop, byte[] keyName, byte[] password) throws ZoroException {
        if (null == commitment || null == encryptedValue || null == encryptedBlindFactor || null == envelop || null == keyName || null == password) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        ArrayList<String> ciphertextList = new ArrayList<String>();
        ciphertextList.add(encryptedValue);
        ciphertextList.add(encryptedBlindFactor);
        List<String> plaintextList = Decryptor.decrypt(ciphertextList, envelop, keyName, password);
        Note note = CommitmentChecker.checkCommitment(commitment, plaintextList.get(0), plaintextList.get(1), encryptedValue, encryptedBlindFactor);
        return note;
    }

    public static boolean verifyCommitment(String commitment, String blindFactor, long value) throws ZoroException {
        if (null == commitment || null == blindFactor) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        ZoroAPI.checkKeyManagementSpi();
        byte[] realBlindFactor = Base64Codec.decode(blindFactor);
        byte[] commit = Base64Codec.decode(commitment);
        boolean ok = false;
        try {
            ok = BulletProof.verifyCommit(commit, realBlindFactor, value);
        }
        catch (CryptoException ex) {
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_NOT_MATCHED, ex.toString());
        }
        return ok;
    }

    public static Note verifyCommitmentChange(String pc, String blindFactor, long value, byte[] keyName, byte[] password, List<? extends EncryptedTuple> positiveTuples, List<? extends EncryptedTuple> negativeTuples) throws ZoroException {
        if (positiveTuples == null && negativeTuples == null || pc == null || blindFactor == null || keyName == null || password == null) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter invalid");
        }
        ZoroAPI.checkKeyManagementSpi();
        byte[] pedersenCommitment = Base64Codec.decode(pc);
        byte[] blindFactorInByte = Base64Codec.decode(blindFactor);
        return Verification.computeCommitmentChange(pedersenCommitment, blindFactorInByte, value, keyName, password, positiveTuples, negativeTuples);
    }

    public static Note verifyCommitmentChange(String pc, String blindFactor, long value, List<? extends PlainTuple> positiveTuples, List<? extends PlainTuple> negativeTuples) throws ZoroException {
        if (positiveTuples == null && negativeTuples == null || pc == null || blindFactor == null || value < 0L) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter invalid");
        }
        ZoroAPI.checkKeyManagementSpi();
        return Verification.computeCommitmentChange(pc, blindFactor, value, positiveTuples, negativeTuples);
    }

    public static String ecdsaSign(byte[] message, byte[] keyName, byte[] password) throws ZoroException {
        byte[] signature = null;
        try {
            signature = CryptoService.getInstance().ecdsaSign(keyName, password, message);
        }
        catch (CryptoException ex) {
            throw new ZoroException(ZoroErrorCodeEnum.ECDSA_SIGN_FAILED, ex.toString());
        }
        return Base64Codec.encode(signature);
    }

    public static boolean ecdsaverify(ECPublicKey pubkey, byte[] message, String signature) throws ZoroException {
        byte[] sigval = Base64Codec.decode(signature);
        boolean verify = false;
        try {
            verify = AlgorithmService.ecdsaVerify(pubkey, message, sigval);
        }
        catch (SignatureException ex) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_ECDSA_SIGNATURE_FORMAT, ex.getMessage());
        }
        catch (InvalidKeyException ex) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_ECDSA_KEY_FORMAT, ex.getMessage());
        }
        catch (CryptoException ex) {
            throw new ZoroException(ZoroErrorCodeEnum.ECDSA_VERIFY_FAILED, ex.getMessage());
        }
        return verify;
    }

    static {
        try {
            NativeLibraryLoader.loadFirstAvailable((ClassLoader)ZoroAPI.class.getClassLoader(), (String[])new String[]{"bulletproof_m_jni"});
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Failed to load java native library: {}", (Throwable)ex);
            }
            throw new ZoroException(ZoroErrorCodeEnum.LOAD_JNI_LIBRARY_EXCEPTION, "Failed to load java native library");
        }
    }
}

