/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.ecdsa;

import com.alipay.mychain.zoro.crypto.ecdsa.AbstractKeyPair;
import com.alipay.mychain.zoro.crypto.ecdsa.ByteUtils;
import com.alipay.mychain.zoro.crypto.ecdsa.ECDSASignature;
import com.alipay.mychain.zoro.crypto.ecdsa.ECSignUtils;
import com.alipay.mychain.zoro.crypto.ecdsa.KeyLoder;
import com.alipay.mychain.zoro.crypto.ecdsa.NumericUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.Arrays;

public class ECKeyPair
extends AbstractKeyPair {
    public ECKeyPair(BigInteger privateKey, BigInteger publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public ECKeyPair(BigInteger privateKey) {
        this.privateKey = privateKey;
        this.publicKey = ECSignUtils.publicKeyFromPrivate(privateKey);
    }

    public ECKeyPair(byte[] privateKey) {
        this.privateKey = NumericUtils.toBigInt(privateKey);
        this.publicKey = ECSignUtils.publicKeyFromPrivate(this.privateKey);
    }

    public ECKeyPair(String privateKey) {
        this.privateKey = NumericUtils.toBigInt(ByteUtils.hexStringToBytes(privateKey));
        this.publicKey = ECSignUtils.publicKeyFromPrivate(this.privateKey);
    }

    public ECKeyPair() throws Exception {
        ECKeyPair keyPair = this.create(this.createKeyPair());
        this.privateKey = keyPair.getPrivateKey();
        this.publicKey = keyPair.getPublicKey();
    }

    @Override
    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    @Override
    public ECDSASignature sign(byte[] transactionHash) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.privateKey, ECSignUtils.CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(transactionHash);
        return new ECDSASignature(components[0], components[1]).toCanonicalised();
    }

    @Override
    public ECKeyPair create(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        BigInteger privateKeyValue = privateKey.getD();
        byte[] publicKeyBytes = publicKey.getQ().getEncoded(false);
        BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange((byte[])publicKeyBytes, (int)1, (int)publicKeyBytes.length));
        return new ECKeyPair(privateKeyValue, publicKeyValue);
    }

    @Override
    public KeyPair createKeyPair() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        KeyPairGenerator generator = KeyPairGenerator.getInstance("ECDSA", "BC");
        generator.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
        return generator.generateKeyPair();
    }

    @Override
    public PrivateKey getEcPrivateKey() throws Exception {
        String name = "secp256k1";
        Security.addProvider((Provider)new BouncyCastleProvider());
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)name);
        ECNamedCurveSpec spec = new ECNamedCurveSpec(name, parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH(), parameterSpec.getSeed());
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(this.getPrivateKey(), (ECParameterSpec)spec);
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        return keyFactory.generatePrivate(keySpec);
    }

    @Override
    public String getHexStringPublicKey() throws Exception {
        return KeyLoder.convertPublicKeyToFixedHexString(this.getPublicKey());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair ecKeyPair = (ECKeyPair)o;
        if (this.privateKey != null ? !this.privateKey.equals(ecKeyPair.privateKey) : ecKeyPair.privateKey != null) {
            return false;
        }
        return this.publicKey != null ? this.publicKey.equals(ecKeyPair.publicKey) : ecKeyPair.publicKey == null;
    }
}

