/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.ecdsa;

import com.alipay.mychain.zoro.crypto.ecdsa.ByteUtils;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeyLoder {
    private static final Logger logger = Logger.getLogger(KeyLoder.class.getName());

    public static String convertPublicKeyToFixedHexString(BigInteger key) throws Exception {
        return KeyLoder.convertToFixedHexString(key, 130, 128);
    }

    public static String convertPrivateKeyToFixedHexString(BigInteger key) throws Exception {
        return KeyLoder.convertToFixedHexString(key, 66, 64);
    }

    public static String convertToFixedHexString(BigInteger key, int totalLength, int expectedLength) throws Exception {
        try {
            byte zero = 48;
            if (key == null) {
                return null;
            }
            String hexString = ByteUtils.toHexString(key.toByteArray());
            byte[] src = hexString.getBytes();
            byte[] dest = new byte[expectedLength];
            if (src.length == totalLength) {
                if (src[0] == zero && src[1] == zero) {
                    System.arraycopy(src, 2, dest, 0, expectedLength);
                }
            } else if (src.length > expectedLength) {
                System.arraycopy(src, 0, dest, 0, expectedLength);
            } else {
                for (int i = 0; i < expectedLength - src.length; ++i) {
                    dest[i] = 48;
                }
                System.arraycopy(src, 0, dest, expectedLength - src.length, src.length);
            }
            return new String(dest);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception("failed to fix hex string", e);
        }
    }
}

