/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.env;

import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.io.InputStream;

public class SslOption
implements ISslOption {
    private String keyFilePath;
    private String certFilePath;
    private String keyPassword;
    private String trustStoreFilePath;
    private String trustStorePassword;

    @Override
    public InputStream getKeyStream() {
        return this.getInputStream(this.keyFilePath);
    }

    public InputStream getInputStream(String filePath) {
        try {
            return this.getClass().getResourceAsStream(filePath);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_GET_FILE_INPUT_STREAM_FAILED);
        }
    }

    @Override
    public InputStream getCertStream() {
        return this.getInputStream(this.certFilePath);
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public InputStream getTrustStoreStream() {
        return this.getInputStream(this.trustStoreFilePath);
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public static class Builder {
        private String keyFilePath;
        private String certFilePath;
        private String keyPassword;
        private String trustStoreFilePath;
        private String trustStorePassword;

        public Builder keyFilePath(String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        public Builder certFilePath(String certFilePath) {
            this.certFilePath = certFilePath;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder trustStoreFilePath(String trustStoreFilePath) {
            this.trustStoreFilePath = trustStoreFilePath;
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public SslOption build() {
            SslOption sslOption = new SslOption();
            sslOption.keyFilePath = this.keyFilePath;
            sslOption.certFilePath = this.certFilePath;
            sslOption.keyPassword = this.keyPassword;
            sslOption.trustStoreFilePath = this.trustStoreFilePath;
            sslOption.trustStorePassword = this.trustStorePassword;
            return sslOption;
        }
    }
}

