/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.service.BaseService;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.query.QueryTransactionReceiptResponse;
import com.alipay.mychain.sdk.message.transaction.envelope.CreateGroupRequest;
import com.alipay.mychain.sdk.message.transaction.envelope.CreateGroupResponse;
import com.alipay.mychain.sdk.message.transaction.envelope.DepositEnvelopeRequest;
import com.alipay.mychain.sdk.message.transaction.envelope.DepositEnvelopeResponse;
import com.alipay.mychain.sdk.message.transaction.envelope.JoinGroupRequest;
import com.alipay.mychain.sdk.message.transaction.envelope.JoinGroupResponse;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;

public class EnvelopeService
extends BaseService {
    public EnvelopeService(INetwork client, TimerTaskManager timerTaskManager, ClientEnv env) {
        super(client, timerTaskManager, env);
    }

    public DepositEnvelopeResponse depositEnvelope(DepositEnvelopeRequest request) {
        if (request.isLocal()) {
            return (DepositEnvelopeResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_DEPOSIT_ENVELOPE, request);
        }
        return (DepositEnvelopeResponse)this.sendSyncTransaction(request);
    }

    public CreateGroupResponse createGroup(CreateGroupRequest request) {
        QueryTransactionReceiptResponse receiptResponse;
        CreateGroupResponse response = (CreateGroupResponse)this.sendSyncRequest(request);
        if (response == null || response.getTxHash() == null) {
            return response;
        }
        Response resp = this.queryReceiptSync(response.getTxHash(), BaseFixedSizeByteArray.Fixed20ByteArray.defaultValue());
        if (resp == null) {
            response.setErrorCode(ErrorCode.TX_IS_NULL);
        }
        if (resp.getErrorCode() != ErrorCode.SUCCESS) {
            response.setErrorCode(resp.getErrorCode());
        }
        if ((receiptResponse = (QueryTransactionReceiptResponse)resp).getTransactionReceipt().getResult() != (long)ErrorCode.SUCCESS.getErrorCode()) {
            response.setErrorCode(ErrorCode.valueOf((int)receiptResponse.getTransactionReceipt().getResult()));
        }
        return response;
    }

    public JoinGroupResponse joinGroup(JoinGroupRequest request) {
        QueryTransactionReceiptResponse receiptResponse;
        JoinGroupResponse response = (JoinGroupResponse)this.sendSyncRequest(request);
        if (response == null || response.getHash() == null) {
            return response;
        }
        Response resp = this.queryReceiptSync(response.getHash(), BaseFixedSizeByteArray.Fixed20ByteArray.defaultValue());
        if (resp == null) {
            response.setErrorCode(ErrorCode.TX_IS_NULL);
        }
        if (resp.getErrorCode() != ErrorCode.SUCCESS) {
            response.setErrorCode(resp.getErrorCode());
        }
        if ((receiptResponse = (QueryTransactionReceiptResponse)resp).getTransactionReceipt().getResult() != (long)ErrorCode.SUCCESS.getErrorCode()) {
            response.setErrorCode(ErrorCode.valueOf((int)receiptResponse.getTransactionReceipt().getResult()));
        }
        return response;
    }

    public int asyncDepositRequest(DepositEnvelopeRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_DEPOSIT_ENVELOPE, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }
}

