/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.block;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.block.BlockBody;
import com.alipay.mychain.sdk.domain.block.BlockHeader;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpList;

public class Block
extends MychainObject {
    private BlockHeader blockHeader;
    private BlockBody blockBody;

    public Block(BlockHeader blockHeader, BlockBody blockBody) {
        this.blockHeader = blockHeader;
        this.blockBody = blockBody;
    }

    public Block() {
    }

    public BlockHeader getBlockHeader() {
        return this.blockHeader;
    }

    public void setBlockHeader(BlockHeader blockHeader) {
        this.blockHeader = blockHeader;
    }

    public Transaction getTransaction(Hash hash) {
        return null == this.blockBody ? null : this.blockBody.getTransactionByHash(hash);
    }

    public BlockBody getBlockBody() {
        return this.blockBody;
    }

    public void setBlockBody(BlockBody blockBody) {
        this.blockBody = blockBody;
    }

    @Override
    public byte[] toRlp() {
        return Rlp.encodeList(this.blockHeader.toRlp(), this.blockBody.toRlp());
    }

    @Override
    public void fromRlp(RlpList list) {
        this.blockHeader = new BlockHeader();
        this.blockHeader.fromRlp((RlpList)list.get(0));
        this.blockBody = new BlockBody();
        this.blockBody.fromRlp((RlpList)list.get(1));
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        JSONObject header = new JSONObject();
        this.blockHeader.toJson(header);
        jsonObject.put("header", (Object)header);
        JSONObject body = new JSONObject();
        this.blockBody.toJson(body);
        jsonObject.put("body", (Object)body);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.blockHeader = new BlockHeader();
        this.blockHeader.fromJson(jsonObject.getJSONObject("header"));
        this.blockBody = new BlockBody();
        this.blockBody.fromJson(jsonObject.getJSONObject("body"));
    }
}

