/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.consensus;

import com.alipay.mychain.sdk.crypto.MyCrypto;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.IHash;
import com.alipay.mychain.sdk.domain.consensus.ProofHash;
import com.alipay.mychain.sdk.trie.MerkleTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Consensus {
    public static int threshold2f(int n) {
        if (n < 1) {
            return 1;
        }
        int f = (n - 1) / 3;
        return (n + f + 1 + 1) / 2;
    }

    public static Hash calcPKsMerkleRootHash(Set<PublicKey> publicKeys) {
        IHash hashTool = HashFactory.getHash();
        Vector<Hash> hashes = new Vector<Hash>();
        for (PublicKey publicKey : publicKeys) {
            byte[] hash = hashTool.hash(publicKey.getValue());
            hashes.add(new Hash(hash));
        }
        Collections.sort(hashes);
        return MerkleTree.root(hashes);
    }

    public static Hash calcProofHash(Hash parentHash, Hash txRoot, Hash pksHash, int nodeSize, long timestamp) {
        ProofHash proofHash = new ProofHash(txRoot, parentHash, nodeSize, timestamp, pksHash);
        byte[] data = proofHash.encode();
        return new Hash(HashFactory.getHash().hash(data));
    }

    public static boolean verifyConsensusProof(List<byte[]> signatures, byte[] digest, Set<PublicKey> publicKeys) {
        int threshold = Consensus.threshold2f(publicKeys.size());
        if (signatures.size() < threshold) {
            return false;
        }
        ArrayList<byte[]> pubkeyList = new ArrayList<byte[]>();
        for (PublicKey publicKey : publicKeys) {
            pubkeyList.add(publicKey.getValue());
        }
        HashSet<Integer> matchedIndex = MyCrypto.getInstance().multiVerify(pubkeyList, signatures, digest);
        return matchedIndex.size() >= threshold;
    }
}

