/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ContractConfig
extends MychainObject {
    private Map<String, String> configs;

    public ContractConfig(Map<String, String> configs) {
        this.configs = configs;
    }

    public ContractConfig() {
        this.configs = new HashMap<String, String>(16);
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> listData = new ArrayList<byte[]>();
        for (Map.Entry<String, String> entry : this.configs.entrySet()) {
            listData.add(Rlp.encodeString(entry.getKey()));
            listData.add(Rlp.encodeString(entry.getValue()));
        }
        return Rlp.encodeList(listData);
    }

    @Override
    public void fromRlp(RlpList list) {
        int length = list.size() / 2;
        for (int i = 0; i < length; ++i) {
            this.configs.put(ByteUtils.byteArrayToString(((RlpElement)list.get(i * 2)).getRlpData()), ByteUtils.byteArrayToString(((RlpElement)list.get(i * 2 + 1)).getRlpData()));
        }
    }

    public void toJson(JSONArray jsonArray) {
        for (Map.Entry<String, String> entry : this.configs.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", (Object)entry.getKey());
            jsonObject.put("value", (Object)entry.getValue());
            jsonArray.add((Object)jsonObject);
        }
    }

    public void fromJson(JSONArray jsonArray) {
        if (jsonArray != null) {
            for (JSONObject jsonObject : jsonArray) {
                this.configs.put(jsonObject.getString("key"), jsonObject.getString("value"));
            }
        }
    }
}

