/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.status.NodeInfo;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class NodeStatus
extends MychainObject {
    private NodeInfo nodeInfo;
    private int isConnected = 0;

    public NodeStatus() {
    }

    public NodeStatus(NodeInfo nodeInfo, int isConnected) {
        this.nodeInfo = nodeInfo;
        this.isConnected = isConnected;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public int getIsConnected() {
        return this.isConnected;
    }

    public void setIsConnected(int isConnected) {
        this.isConnected = isConnected;
    }

    @Override
    public byte[] toRlp() {
        byte[] nodeInfoBytes = this.nodeInfo.toRlp();
        byte[] isConnectedBytes = Rlp.encodeInt(this.isConnected);
        return Rlp.encodeList(nodeInfoBytes, isConnectedBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.nodeInfo = new NodeInfo();
        this.nodeInfo.fromRlp((RlpList)list.get(0));
        this.isConnected = ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        JSONObject object = new JSONObject();
        this.nodeInfo.toJson(object);
        jsonObject.put("info", (Object)object);
        jsonObject.put("isConnected", (Object)this.isConnected);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.nodeInfo = new NodeInfo();
        this.nodeInfo.fromJson(jsonObject.getJSONObject("info"));
        this.isConnected = jsonObject.getIntValue("isConnected");
    }
}

