/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.contract.Contract;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryContractResponse
extends Response {
    private BigInteger blockNumber = BigInteger.ZERO;
    private Contract contract;

    public QueryContractResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_CONTRACT);
    }

    public QueryContractResponse(Contract contract, BigInteger blockNumber) {
        super(MessageType.MSG_TYPE_QUERY_RESP_CONTRACT);
        this.contract = contract;
        this.blockNumber = blockNumber;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public byte[] toRlp() {
        byte[] contractBytes = this.contract.toRlp();
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        return Rlp.encodeList(super.toRlp(), contractBytes, blockNumberBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.contract = new Contract();
        this.contract.fromRlp((RlpList)list.get(1));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONObject object = new JSONObject();
        this.contract.toJson(object);
        jsonObject.put("contract", (Object)object);
        jsonObject.put("block_number", (Object)this.blockNumber);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.contract = new Contract();
        this.contract.fromJson(jsonObject.getJSONObject("contract"));
        this.blockNumber = jsonObject.getBigInteger("block_number");
    }
}

