/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryTransactionListResponse
extends Response {
    private List<Transaction> transactions;

    public QueryTransactionListResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_LIST);
    }

    public QueryTransactionListResponse(List<Transaction> transactions) {
        super(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_LIST);
        this.transactions = transactions;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (Transaction item : this.transactions) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(super.toRlp(), Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.transactions = new ArrayList<Transaction>();
        RlpList data = (RlpList)list.get(1);
        for (RlpElement element : data) {
            Transaction item = new Transaction();
            item.fromRlp((RlpList)element);
            this.transactions.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONArray jsonArray = new JSONArray();
        if (this.transactions != null) {
            for (Transaction item : this.transactions) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("transactions", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.transactions = new ArrayList<Transaction>();
        JSONArray jsonArray = jsonObject.getJSONArray("transactions");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                Transaction object = new Transaction();
                object.fromJson((JSONObject)iterator.next());
                this.transactions.add(object);
            }
        }
    }
}

