/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryBlockProofRequest
extends Request {
    private BigInteger blockNumber = BigInteger.ZERO;
    private Hash hash = new Hash();

    public QueryBlockProofRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_PROOF);
    }

    public QueryBlockProofRequest(Hash hash) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_PROOF);
        this.hash = hash;
    }

    public QueryBlockProofRequest(BigInteger blockNumber) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_PROOF);
        this.blockNumber = blockNumber;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.hash != null && !this.hash.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue()) || this.blockNumber != null) && this.blockNumber.compareTo(BigInteger.ZERO) >= 0;
    }

    @Override
    public byte[] toRlp() {
        byte[] block_number = Rlp.encodeBigInteger(this.blockNumber);
        byte[] hash_ = Rlp.encodeElement(this.hash.getValue());
        return Rlp.encodeList(super.toRlp(), block_number, hash_);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.hash = new Hash(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("block_number", (Object)this.blockNumber);
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.hash.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.hash = new Hash(jsonObject.getString("hash"));
    }
}

