/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryBlockCacheStatusRequest
extends Request {
    private Hash nodeId = new Hash();

    public QueryBlockCacheStatusRequest(Hash nodeId) {
        super(MessageType.MSG_TYPE_STATUS_REQ_BLOCK_CACHE);
        this.nodeId = nodeId;
    }

    public QueryBlockCacheStatusRequest() {
        super(MessageType.MSG_TYPE_STATUS_REQ_BLOCK_CACHE);
    }

    public Hash getNodeId() {
        return this.nodeId;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.nodeId != null;
    }

    @Override
    public byte[] toRlp() {
        byte[] nodeIdBytes = Rlp.encodeElement(this.nodeId.getValue());
        return Rlp.encodeList(super.toRlp(), nodeIdBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.nodeId = new Hash(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("node_id", (Object)ByteUtils.toHexString(this.nodeId.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.nodeId = new Hash(jsonObject.getString("node_id"));
    }
}

