/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class TransactionReceiptResponse
extends Response {
    private TransactionReceipt transactionReceipt = new TransactionReceipt();
    private BigInteger blockNumber = BigInteger.ZERO;
    private int txIndex = 0;
    private Hash txHash = new Hash();
    private boolean isLocalTransaction = false;

    public TransactionReceiptResponse() {
        super(MessageType.MSG_TYPE_TX_RESP_LOCAL);
    }

    public TransactionReceiptResponse(MessageType type) {
        super(type);
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(Hash txHash) {
        this.txHash = txHash;
    }

    public TransactionReceipt getTransactionReceipt() {
        return this.transactionReceipt;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public void setTxIndex(int txIndex) {
        this.txIndex = txIndex;
    }

    public boolean isLocalTransaction() {
        return this.isLocalTransaction;
    }

    public void setLocalTransaction() {
        this.isLocalTransaction = true;
    }

    @Override
    public byte[] toRlp() {
        byte[] hashBytes = Rlp.encodeElement(this.txHash.getValue());
        byte[] receiptBytes = this.transactionReceipt.toRlp();
        byte[] numberBytes = Rlp.encodeBigInteger(this.blockNumber);
        byte[] indexBytes = Rlp.encodeInt(this.txIndex);
        return Rlp.encodeList(super.toRlp(), hashBytes, receiptBytes, numberBytes, indexBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        if (this.getMessageType() == MessageType.MSG_TYPE_TX_RESP_LOCAL) {
            this.txHash = new Hash(ByteUtils.toHexString(((RlpElement)list.get(1)).getRlpData()));
            this.transactionReceipt.fromRlp((RlpList)list.get(2));
            this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(3)).getRlpData());
            this.txIndex = ByteUtils.byteArrayToInt(((RlpElement)list.get(4)).getRlpData());
            this.setLocalTransaction();
        } else {
            this.txHash = new Hash(ByteUtils.toHexString(((RlpElement)list.get(1)).getRlpData()));
            this.transactionReceipt.fromRlp((RlpList)list.get(2));
            this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(3)).getRlpData());
            this.txIndex = ByteUtils.byteArrayToInt(((RlpElement)list.get(4)).getRlpData());
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        if (!this.isLocalTransaction()) {
            jsonObject.put("hash", (Object)ByteUtils.toHexString(this.txHash.getValue()));
        } else {
            jsonObject.put("hash", (Object)ByteUtils.toHexString(this.txHash.getValue()));
            JSONObject object = new JSONObject();
            this.transactionReceipt.toJson(object);
            jsonObject.put("receipt", (Object)object);
            jsonObject.put("block_number", (Object)this.getBlockNumber());
            jsonObject.put("tx_index", (Object)this.getTxIndex());
        }
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        if (this.getMessageType() != MessageType.MSG_TYPE_TX_RESP_LOCAL) {
            this.txHash = new Hash(jsonObject.getString("hash"));
        } else {
            this.txHash = new Hash(jsonObject.getString("hash"));
            this.transactionReceipt.fromJson(jsonObject.getJSONObject("receipt"));
            this.blockNumber = jsonObject.getBigInteger("block_number");
            this.txIndex = jsonObject.getIntValue("tx_index");
            this.setLocalTransaction();
        }
    }
}

