/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.confidential;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.domain.transaction.LogEntry;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.TransactionReceiptResponse;
import org.apache.commons.lang3.ArrayUtils;

public class ConfidentialResponse
extends TransactionReceiptResponse {
    public ConfidentialResponse() {
        super(MessageType.MSG_TYPE_TX_RESP_CONFIDENTIAL_TX);
    }

    public TransactionReceipt getReceipt(byte[] decryptionKey) {
        TransactionReceipt transactionReceipt = new TransactionReceipt();
        transactionReceipt.setLogs(this.getTransactionReceipt().getLogs());
        transactionReceipt.setGasUsed(this.getTransactionReceipt().getGasUsed());
        transactionReceipt.setResult(this.getTransactionReceipt().getResult());
        transactionReceipt.setOutput(this.getTransactionReceipt().getOutput());
        if (ArrayUtils.isEmpty((byte[])decryptionKey)) {
            return transactionReceipt;
        }
        try {
            AesGcmCipherV1 aesGcmCipherV1 = new AesGcmCipherV1(decryptionKey);
            byte[] algoId = AlgoIdEnum.CIPHER_AES_GCM_LOCAL_V1.toBytes();
            if (ArrayUtils.isNotEmpty((byte[])transactionReceipt.getOutput()) && transactionReceipt.getOutput().length >= 28) {
                byte[] ciphertext = new byte[transactionReceipt.getOutput().length + 2];
                System.arraycopy(algoId, 0, ciphertext, 0, 2);
                System.arraycopy(transactionReceipt.getOutput(), transactionReceipt.getOutput().length - 28, ciphertext, 2, 28);
                System.arraycopy(transactionReceipt.getOutput(), 0, ciphertext, 30, transactionReceipt.getOutput().length - 28);
                byte[] result = aesGcmCipherV1.decrypt(ciphertext);
                transactionReceipt.setOutput(result);
            }
            for (LogEntry logEntry : transactionReceipt.getLogs()) {
                if (ArrayUtils.isEmpty((byte[])logEntry.getLogData()) || logEntry.getLogData().length < 28) continue;
                byte[] ciphertext = new byte[logEntry.getLogData().length + 2];
                System.arraycopy(algoId, 0, ciphertext, 0, 2);
                System.arraycopy(logEntry.getLogData(), logEntry.getLogData().length - 28, ciphertext, 2, 28);
                System.arraycopy(logEntry.getLogData(), 0, ciphertext, 30, logEntry.getLogData().length - 28);
                byte[] data = aesGcmCipherV1.decrypt(ciphertext);
                logEntry.setLogData(data);
            }
        }
        catch (Throwable e) {
            return this.getTransactionReceipt();
        }
        return transactionReceipt;
    }
}

