/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty;

import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.api.env.NetworkOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.MessageDecoder;
import com.alipay.mychain.sdk.network.MessageEncoder;
import com.alipay.mychain.sdk.network.netty.AbstractClientTransport;
import com.alipay.mychain.sdk.network.netty.ClientSslContext;
import com.alipay.mychain.sdk.network.netty.IChannelHandler;
import com.alipay.mychain.sdk.network.netty.INetEventHandler;
import com.alipay.mychain.sdk.network.netty.handler.MessageDuplexHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslContext;

public class TcpClientTransport
extends AbstractClientTransport {
    private INetEventHandler eventHandler;

    public TcpClientTransport(INetEventHandler eventHandler, NetworkOption networkOption, ISslOption sslOption, ILogger logger) {
        super(networkOption, sslOption, logger);
        this.eventHandler = eventHandler;
    }

    @Override
    protected void initChannelHandlers() {
        ClientSslContext clientSslContext = new ClientSslContext(this.sslOption, this.logger);
        final SslContext sslContext = clientSslContext.createSslContext();
        if (sslContext != null) {
            this.addChannelHandler("ssl", new IChannelHandler(){

                @Override
                public ChannelHandler getHandler(Channel channel) {
                    return sslContext.newHandler(channel.alloc());
                }
            });
        }
        this.addChannelHandler("encoder", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new MessageEncoder(TcpClientTransport.this.logger);
            }
        });
        this.addChannelHandler("decoder", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new MessageDecoder(TcpClientTransport.this.logger);
            }
        });
        this.addChannelHandler("tcp_msg_handler", new IChannelHandler(){

            @Override
            public ChannelHandler getHandler(Channel channel) {
                return new MessageDuplexHandler(TcpClientTransport.this.eventHandler, TcpClientTransport.this.logger);
            }
        });
    }
}

