/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.utils;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorUtils {
    private static final int DEFAULT_THREADS = Math.max(1, Runtime.getRuntime().availableProcessors() * 2);

    public static ThreadFactory getNamedThreadFactory(String name) {
        return ExecutorUtils.getNamedThreadFactory(name, false);
    }

    public static ThreadFactory getNamedThreadFactory(String name, boolean isDaemon) {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setDaemon(isDaemon).setNameFormat(name + "-thread-%d");
        return builder.build();
    }

    public static ScheduledExecutorService getScheduledExecutorService(String name) {
        return ExecutorUtils.getScheduledExecutorService(name, 1);
    }

    public static ScheduledExecutorService getScheduledExecutorService(String name, int corePoolSize) {
        return ExecutorUtils.getScheduledExecutorService(corePoolSize, ExecutorUtils.getNamedThreadFactory(name));
    }

    public static ScheduledExecutorService getScheduledExecutorService(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public static ListeningExecutorService getListeningExecutorService(String name, int maxPendingTasks) {
        return ExecutorUtils.getListeningExecutorService(DEFAULT_THREADS, name, maxPendingTasks);
    }

    public static ListeningExecutorService getListeningExecutorService(int nThreads, String name, int maxPendingTasks) {
        return ExecutorUtils.getListeningExecutorService(nThreads, ExecutorUtils.getNamedThreadFactory(name), maxPendingTasks);
    }

    public static ListeningExecutorService getListeningExecutorService(int nThreads, ThreadFactory threadFactory, int maxPendingTasks) {
        ThreadPoolExecutor es = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxPendingTasks), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        return ExecutorUtils.getListeningExecutorService(es);
    }

    public static ListeningExecutorService getListeningExecutorService(ExecutorService executorService) {
        return MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    public static int getDefaultThreads() {
        return DEFAULT_THREADS;
    }
}

