/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm;

import com.alipay.mychain.sdk.vm.VMOutput;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Int16;
import com.alipay.mychain.sdk.vm.abi.datatype.Int32;
import com.alipay.mychain.sdk.vm.abi.datatype.Int64;
import com.alipay.mychain.sdk.vm.abi.datatype.Int8;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint16;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint32;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint64;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint8;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import com.alipay.mychain.sdk.vm.wasm.MyWasmTypeDecoder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class WASMOutput
extends VMOutput {
    private String rawOutput;
    private int offset = 0;

    public WASMOutput() {
    }

    public WASMOutput(String rawOutput) {
        this.rawOutput = Numeric.cleanHexPrefix(rawOutput);
    }

    public BigInteger getInt8() {
        Int8 value = MyWasmTypeDecoder.decodeInt8(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Int8.class).getCutString().length();
        return result;
    }

    public BigInteger getInt16() {
        Int16 value = MyWasmTypeDecoder.decodeInt16(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Int16.class).getCutString().length();
        return result;
    }

    public BigInteger getInt32() {
        Int32 value = MyWasmTypeDecoder.decodeInt32(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Int32.class).getCutString().length();
        return result;
    }

    public BigInteger getInt64() {
        Int64 value = MyWasmTypeDecoder.decodeInt64(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Int64.class).getCutString().length();
        return result;
    }

    public BigInteger getUint8() {
        Uint8 value = MyWasmTypeDecoder.decodeUint8(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Uint8.class).getCutString().length();
        return result;
    }

    public BigInteger getUint16() {
        Uint16 value = MyWasmTypeDecoder.decodeUint16(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Uint16.class).getCutString().length();
        return result;
    }

    public BigInteger getUint32() {
        Uint32 value = MyWasmTypeDecoder.decodeUint32(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Uint32.class).getCutString().length();
        return result;
    }

    public BigInteger getUint64() {
        Uint64 value = MyWasmTypeDecoder.decodeUint64(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Uint64.class).getCutString().length();
        return result;
    }

    public boolean getBoolean() {
        Bool value = MyWasmTypeDecoder.decodeBool(this.rawOutput, this.offset);
        boolean result = (Boolean)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Bool.class).getCutString().length();
        return result;
    }

    public String getString() {
        Utf8String value = MyWasmTypeDecoder.decodeUtf8String(this.rawOutput, this.offset);
        String result = (String)value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, Utf8String.class).getCutString().length();
        return result;
    }

    public byte[] getBytes() {
        DynamicBytes value = MyWasmTypeDecoder.decodeDynamicBytes(this.rawOutput, this.offset);
        byte[] result = (byte[])value.getValue();
        this.offset += MyWasmTypeDecoder.getDataOffset(this.rawOutput, this.offset, DynamicBytes.class).getCutString().length();
        return result;
    }

    public <T extends Type> List<BigInteger> getIntAndUintDynamicArray(Class<T> type) {
        Type value = MyWasmTypeDecoder.decodeUintAndIntDynamicArray(this.rawOutput, this.offset, type);
        List values = (List)value.getValue();
        ArrayList<BigInteger> bigs = new ArrayList<BigInteger>();
        for (Type val : values) {
            bigs.add((BigInteger)val.getValue());
        }
        this.offset += MyWasmTypeDecoder.getDataArrayOffset(this.rawOutput, this.offset, type).getCutString().length();
        return bigs;
    }

    public List<Boolean> getBooleanDynamicArray() {
        Type value = MyWasmTypeDecoder.decodeBoolDynamicArray(this.rawOutput, this.offset);
        List values = (List)value.getValue();
        ArrayList<Boolean> bigs = new ArrayList<Boolean>();
        for (Bool val : values) {
            bigs.add(val.getValue());
        }
        this.offset += MyWasmTypeDecoder.getDataArrayOffset(this.rawOutput, this.offset, Bool.class).getCutString().length();
        return bigs;
    }

    public List<String> getStringDynamicArray() {
        Utf8String value = MyWasmTypeDecoder.decodeDynamicArrayForDynamicItemLength(this.rawOutput, this.offset, Utf8String.class);
        List values = (List)value.getValue();
        ArrayList<String> stringList = new ArrayList<String>();
        for (Utf8String val : values) {
            stringList.add(val.getValue());
        }
        this.offset += MyWasmTypeDecoder.getDataArrayOffset(this.rawOutput, this.offset, Utf8String.class).getCutString().length();
        return stringList;
    }

    public String getRawOutput() {
        return this.rawOutput;
    }

    @Override
    public void setRawOutput(String rawOutput) {
        this.rawOutput = rawOutput;
    }
}

