/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.wasm;

import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.vm.abi.DynamicArrayInterface;
import com.alipay.mychain.sdk.vm.abi.datatype.AbstractArray;
import com.alipay.mychain.sdk.vm.abi.datatype.AbstractNumericType;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicArray;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Int16;
import com.alipay.mychain.sdk.vm.abi.datatype.Int32;
import com.alipay.mychain.sdk.vm.abi.datatype.Int64;
import com.alipay.mychain.sdk.vm.abi.datatype.Int8;
import com.alipay.mychain.sdk.vm.abi.datatype.StaticArray;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint16;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint32;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint64;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint8;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import com.alipay.mychain.sdk.vm.utils.Utils;
import com.alipay.mychain.sdk.vm.wasm.DecodeNext;
import com.alipay.mychain.sdk.vm.wasm.Leb128Utils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class MyWasmTypeDecoder {
    public static Uint8 decodeUint8(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Uint8.class).getRemainData(), Uint8.class);
    }

    public static Uint16 decodeUint16(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Uint16.class).getRemainData(), Uint16.class);
    }

    public static Uint32 decodeUint32(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Uint32.class).getRemainData(), Uint32.class);
    }

    public static Uint64 decodeUint64(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Uint64.class).getRemainData(), Uint64.class);
    }

    public static Int8 decodeInt8(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Int8.class).getRemainData(), Int8.class);
    }

    public static Int16 decodeInt16(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Int16.class).getRemainData(), Int16.class);
    }

    public static Int32 decodeInt32(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Int32.class).getRemainData(), Int32.class);
    }

    public static Int64 decodeInt64(String rawInput, int offset) {
        return MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawInput, offset, Int64.class).getRemainData(), Int64.class);
    }

    public static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset);
        byte[] inputBytes = ByteUtils.hexStringToBytes(input);
        byte[] boolBytes = new byte[]{inputBytes[0]};
        input = ByteUtils.toHexString(boolBytes);
        BigInteger numericValue = Numeric.toBigInt(input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    public static DynamicBytes decodeDynamicBytes(String input, int offset) {
        byte[] bytes = Numeric.hexStringToByteArray(MyWasmTypeDecoder.getDataArrayOffset(input, offset, Bytes.class).getRemainData());
        return new DynamicBytes(bytes);
    }

    public static Utf8String decodeUtf8String(String input, int offset) {
        DynamicBytes dynamicBytesResult = MyWasmTypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    public static <T extends Type> Type decodeUintAndIntDynamicArray(String input, int offset, Class<T> type) {
        return MyWasmTypeDecoder.decodeDynamicArray(MyWasmTypeDecoder.getDataArrayOffset((String)input, (int)offset, type).remainData, MyWasmTypeDecoder.getDataArrayOffset((String)input, (int)offset, type).headerLength, type);
    }

    public static Type decodeBoolDynamicArray(String input, int offset) {
        return MyWasmTypeDecoder.decodeDynamicArray(MyWasmTypeDecoder.getDataArrayOffset((String)input, (int)offset, Bool.class).remainData, MyWasmTypeDecoder.getDataArrayOffset((String)input, (int)offset, Bool.class).headerLength, Bool.class);
    }

    public static <T extends Type> T decodeDynamicArrayForDynamicItemLength(String input, int offset, Class<T> type) {
        DynamicArrayInterface dynamicArrayInterface = new DynamicArrayInterface<T>(){

            @Override
            public T apply(List<T> elements, String typeName) {
                if (elements.isEmpty()) {
                    return DynamicArray.empty(typeName);
                }
                return new DynamicArray(elements);
            }
        };
        ArrayList<T> elements = new ArrayList<T>();
        DecodeNext decodeNext = new DecodeNext();
        byte[] dataSource = ByteUtils.hexStringToBytes(input.substring(offset));
        byte[] headerLengthBytes = Leb128Utils.getInputHeaderLengthBytes(dataSource, decodeNext);
        if (ArrayUtils.isEmpty((byte[])headerLengthBytes)) {
            return (T)((Type)dynamicArrayInterface.apply(elements, Utils.getSimpleTypeName(type)));
        }
        int headerLength = decodeNext.getHeaderLength();
        offset += ByteUtils.toHexString(headerLengthBytes).length();
        for (int i = 0; i < headerLength; ++i) {
            elements.add(MyWasmTypeDecoder.decode(input, offset, type));
            offset += MyWasmTypeDecoder.getDataOffset((String)input, (int)offset, type).cutString.length();
        }
        return (T)((Type)dynamicArrayInterface.apply(elements, Utils.getSimpleTypeName(type)));
    }

    private static <T extends Type> T decode(String input, int offset, Class<T> type) {
        if (AbstractNumericType.class.isAssignableFrom(type)) {
            return MyWasmTypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)MyWasmTypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return MyWasmTypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)MyWasmTypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)MyWasmTypeDecoder.decodeUtf8String(input, offset);
        }
        if (AbstractArray.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("AbstractArray types must be wrapped in a Type");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    public static <T extends Type> int getClassSingleByteLength(Class<T> type) {
        return MyWasmTypeDecoder.getClassSingleByteLength(type, "");
    }

    public static <T extends Type> int getClassSingleByteLength(Class<T> type, String input) {
        int typeLengthAsBytes = 0;
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type) || Bytes.class.isAssignableFrom(type)) {
            typeLengthAsBytes = 1;
            return typeLengthAsBytes;
        }
        if (Bool.class.isAssignableFrom(type)) {
            typeLengthAsBytes = 1;
            return typeLengthAsBytes;
        }
        if (Uint8.class.isAssignableFrom(type) || Int8.class.isAssignableFrom(type)) {
            typeLengthAsBytes = 1;
            return typeLengthAsBytes;
        }
        if (Uint16.class.isAssignableFrom(type) || Int16.class.isAssignableFrom(type)) {
            typeLengthAsBytes = 2;
            return typeLengthAsBytes;
        }
        if (Uint32.class.isAssignableFrom(type) || Int32.class.isAssignableFrom(type)) {
            typeLengthAsBytes = 4;
            return typeLengthAsBytes;
        }
        if (Uint64.class.isAssignableFrom(type) || Int64.class.isAssignableFrom(type)) {
            typeLengthAsBytes = 8;
            return typeLengthAsBytes;
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return 0;
        }
        if (typeLengthAsBytes == 0) {
            throw new UnsupportedOperationException("unsupport number type exception.");
        }
        return typeLengthAsBytes;
    }

    private static <T extends AbstractNumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            int typeLengthAsBytes = MyWasmTypeDecoder.getClassSingleByteLength(type);
            byte[] inputByteArray = Numeric.hexStringToByteArray(input);
            byte[] currentDataArray = new byte[typeLengthAsBytes];
            System.arraycopy(inputByteArray, 0, currentDataArray, 0, typeLengthAsBytes);
            ArrayUtils.reverse((byte[])currentDataArray);
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int8.class.isAssignableFrom(type) || Int16.class.isAssignableFrom(type) || Int32.class.isAssignableFrom(type) || Int64.class.isAssignableFrom(type)) {
                byte signNum = currentDataArray[0];
                resultByteArray[0] = (signNum = (byte)(signNum & 0x80)) == 0 ? 0 : -1;
            }
            System.arraycopy(currentDataArray, 0, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((AbstractNumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    private static <T extends Type> T decodeDynamicArray(String input, int arrayLength, Class<T> type) {
        DynamicArrayInterface dynamicArrayInterface = new DynamicArrayInterface<T>(){

            @Override
            public T apply(List<T> elements, String typeName) {
                if (elements.isEmpty()) {
                    return DynamicArray.empty(typeName);
                }
                return new DynamicArray(elements);
            }
        };
        return MyWasmTypeDecoder.decodeArrayElements(input, type, arrayLength, dynamicArrayInterface);
    }

    private static <T extends Type> T instantiateStaticArray(Class<T> type, List<T> elements) {
        try {
            Class<List> listClass = List.class;
            return (T)((Type)type.getConstructor(listClass).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            return (T)new StaticArray<T>(elements);
        }
    }

    private static <T extends Type> T decodeArrayElements(String input, Class<T> type, int length, DynamicArrayInterface<T> dynamicArrayInterface) {
        int singleLength = MyWasmTypeDecoder.getClassSingleByteLength(type);
        if (AbstractArray.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Arrays of arrays are not currently supported for external functions, seehttp://solidity.readthedocs.io/en/develop/types.html#members");
        }
        ArrayList<T> elements = new ArrayList<T>(length);
        byte[] data = ByteUtils.hexStringToBytes(input);
        int i = 0;
        int currOffset = 0;
        while (i < length) {
            byte[] current = new byte[singleLength];
            System.arraycopy(data, i * singleLength, current, 0, singleLength);
            T value = MyWasmTypeDecoder.decode(ByteUtils.toHexString(current), 0, type);
            elements.add(value);
            ++i;
            currOffset += singleLength;
        }
        String typeName = Utils.getSimpleTypeName(type);
        return (T)((Type)dynamicArrayInterface.apply(elements, typeName));
    }

    private static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray(input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    public static <T extends Type> DecodeNext getDataOffset(String input, int offset, Class<T> type) {
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            input = input.substring(offset);
            return Leb128Utils.decodeLeb(input, type);
        }
        input = input.substring(offset);
        DecodeNext decodeNext = new DecodeNext(0, input);
        int typeLengthAsBytes = MyWasmTypeDecoder.getClassSingleByteLength(type, input);
        byte[] inputByteArray = Numeric.hexStringToByteArray(input);
        byte[] currentDataArray = new byte[typeLengthAsBytes];
        System.arraycopy(inputByteArray, 0, currentDataArray, 0, typeLengthAsBytes);
        decodeNext.setCutString(ByteUtils.toHexString(currentDataArray));
        return decodeNext;
    }

    public static <T extends Type> DecodeNext getDataArrayOffset(String input, int offset, Class<T> type) {
        input = input.substring(offset);
        return Leb128Utils.decodeLeb(input, type);
    }
}

