/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.cryptoservice;

import com.alipay.mychain.zoro.crypto.AlgorithmService;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoContext;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoServiceDefault;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoServiceSpi;
import com.alipay.mychain.zoro.crypto.ecdsa.ECDSASignature;
import com.alipay.mychain.zoro.crypto.ecdsa.ECSignUtils;
import com.alipay.mychain.zoro.crypto.ecdsa.NumericUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Logger;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.util.Arrays;

public class CryptoService {
    private static final Logger logger = Logger.getLogger(CryptoService.class.getName());
    private static int PUBKEYENCDODEDLENGTH = 88;
    private CryptoServiceSpi cryptoServiceSpi;

    CryptoService(CryptoServiceSpi cryptoServiceSpi) {
        this.cryptoServiceSpi = cryptoServiceSpi;
    }

    public static CryptoService getInstance() {
        CryptoServiceSpi sp = CryptoContext.getCryptoServiceSpi();
        if (null == sp) {
            sp = CryptoServiceDefault.getInstance();
        }
        return new CryptoService(sp);
    }

    public byte[] rsa2048Decrypt(byte[] keyname, byte[] password, byte[] ciphertext) throws CryptoException {
        if (this.cryptoServiceSpi == null) {
            throw new CryptoException("Crypto Service Spi is null.");
        }
        return this.cryptoServiceSpi.rsa2048Decrypt(keyname, password, ciphertext);
    }

    public byte[] ecdsaSign(byte[] keyname, byte[] password, byte[] message) throws CryptoException {
        if (this.cryptoServiceSpi == null) {
            throw new CryptoException("Crypto Service Spi is null.");
        }
        try {
            byte[] concatPubkeyDerSign = this.cryptoServiceSpi.ecdsaSign(keyname, password, message);
            if (concatPubkeyDerSign.length < PUBKEYENCDODEDLENGTH + 8 || concatPubkeyDerSign.length > PUBKEYENCDODEDLENGTH + 72) {
                throw new CryptoException("The length of pubkey||signature return from cryptoServiceSpi is wrong.");
            }
            byte[] pubkeyInBytes = new byte[PUBKEYENCDODEDLENGTH];
            byte[] signDerInBytes = new byte[concatPubkeyDerSign.length - PUBKEYENCDODEDLENGTH];
            System.arraycopy(concatPubkeyDerSign, 0, pubkeyInBytes, 0, PUBKEYENCDODEDLENGTH);
            System.arraycopy(concatPubkeyDerSign, PUBKEYENCDODEDLENGTH, signDerInBytes, 0, concatPubkeyDerSign.length - PUBKEYENCDODEDLENGTH);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(pubkeyInBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            ECPublicKey pubkey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            ECDSASignature sig = ECDSASignature.decodeFromDER(signDerInBytes);
            ECPublicKeyParameters bcecPublicKey = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)pubkey);
            byte[] pubkeyEncode = bcecPublicKey.getQ().getEncoded(false);
            BigInteger x = new BigInteger(1, Arrays.copyOfRange((byte[])pubkeyEncode, (int)1, (int)pubkeyEncode.length));
            byte[] hashMessage = AlgorithmService.sha256(message);
            int recId = -1;
            int length = 4;
            for (int i = 0; i < length; ++i) {
                BigInteger k = ECSignUtils.recoverFromSignature(i, sig, hashMessage);
                if (k == null || !k.equals(x)) continue;
                recId = i;
                break;
            }
            if (recId == -1) {
                throw new CryptoException("Could not construct a recoverable key. This should never happen.");
            }
            int headerByte = recId;
            byte v = (byte)headerByte;
            byte[] r = NumericUtils.toBytesPadded(sig.r, 32);
            byte[] s = NumericUtils.toBytesPadded(sig.s, 32);
            byte[] sigStream = new byte[65];
            System.arraycopy(r, 0, sigStream, 0, 32);
            System.arraycopy(s, 0, sigStream, 32, 32);
            sigStream[64] = v;
            return sigStream;
        }
        catch (Exception e) {
            throw new CryptoException("Signature fail", e);
        }
    }
}

