/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.event;

import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.EventService;
import com.alipay.mychain.sdk.domain.event.EventDataType;
import com.alipay.mychain.sdk.domain.event.EventModelType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import java.math.BigInteger;

public class EventRegisterTask
extends AbstractTask {
    private EventService eventService;
    private TimerTaskManager taskManager;
    private Request request;
    private IEventCallback callback;
    private EventDataType eventDataType;
    private EventModelType eventModelType;

    public EventRegisterTask(EventService eventService, TimerTaskManager taskManager, Request request, IEventCallback callback, EventDataType eventDataType, EventModelType eventModelType, ILogger logger) {
        super(1000, TaskType.ONCE, logger);
        this.eventService = eventService;
        this.taskManager = taskManager;
        this.request = request;
        this.callback = callback;
        this.eventDataType = eventDataType;
        this.eventModelType = eventModelType;
    }

    @Override
    public void run() {
        if (this.taskManager == null || this.request == null || this.eventService == null) {
            return;
        }
        BigInteger eventId = this.eventService.listenEvent(this.request, this.callback, this.eventDataType, this.eventModelType);
        if (eventId.compareTo(BigInteger.ZERO) == 0) {
            EventRegisterTask registerTask = new EventRegisterTask(this.eventService, this.taskManager, this.request, this.callback, this.eventDataType, this.eventModelType, this.logger);
            this.taskManager.registerTask(registerTask);
        }
    }
}

