/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.spv;

import com.alipay.mychain.sdk.api.MychainClient;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.spv.AbstractSpvProxy;
import com.alipay.mychain.sdk.api.service.spv.LogFilter;
import com.alipay.mychain.sdk.api.service.spv.SpvTask;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.crypto.hash.IHash;
import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.domain.block.BlockBody;
import com.alipay.mychain.sdk.domain.block.BlockHeader;
import com.alipay.mychain.sdk.domain.consensus.Consensus;
import com.alipay.mychain.sdk.domain.consensus.honeyBadger.HBConsensusProofInfo;
import com.alipay.mychain.sdk.domain.consensus.honeyBadger.HoneyBadger;
import com.alipay.mychain.sdk.domain.consensus.pbft.Pbft;
import com.alipay.mychain.sdk.domain.consensus.pbft.PbftConsensusProofInfo;
import com.alipay.mychain.sdk.domain.contract.Contract;
import com.alipay.mychain.sdk.domain.spv.BlockBodyInfo;
import com.alipay.mychain.sdk.domain.spv.BlockHeaderInfo;
import com.alipay.mychain.sdk.domain.spv.BlockHeaderProof;
import com.alipay.mychain.sdk.domain.spv.ContractNodeState;
import com.alipay.mychain.sdk.domain.spv.ReceiptProof;
import com.alipay.mychain.sdk.domain.spv.TransactionProof;
import com.alipay.mychain.sdk.domain.spv.VerifiedBlock;
import com.alipay.mychain.sdk.domain.spv.WorldStateNode;
import com.alipay.mychain.sdk.domain.spv.WorldStateProof;
import com.alipay.mychain.sdk.domain.transaction.LogEntry;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.spv.QueryBlockBodiesRequest;
import com.alipay.mychain.sdk.message.spv.QueryBlockBodiesResponse;
import com.alipay.mychain.sdk.message.spv.QueryReceiptProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryReceiptProofResponse;
import com.alipay.mychain.sdk.message.spv.QueryStateProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryStateProofResponse;
import com.alipay.mychain.sdk.message.spv.QueryTransactionProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryTransactionProofResponse;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import com.alipay.mychain.sdk.trie.MerkleTree;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;

public class SpvImp {
    private static final String SYSTEM_EVENT_DELETE_NODE = ByteUtils.toHexString(HashFactory.getHash(HashTypeEnum.Keccak).hash(ByteUtils.stringToByteArray("NodeDelete(bytes32,bytes,uint8)")));
    private static final String SYSTEM_EVENT_ACTIVATE_NODE = ByteUtils.toHexString(HashFactory.getHash(HashTypeEnum.Keccak).hash(ByteUtils.stringToByteArray("NodeActive(bytes32,bytes,uint8)")));
    private static final Hash SYSTEM_CONTRACT_NODE = new Hash("e93372533f323b2f12783aa3a586135cf421486439c2cdcde47411b78f9839ec");
    private VerifiedBlock verifiedBlock;
    private AbstractSpvProxy proxy;
    private INetwork network;
    private TimerTaskManager timerTaskManager;
    private Integer timeout = 0;
    private Long taskId = 0L;
    private ILogger logger;
    private LogFilter logFilter = new LogFilter();

    public SpvImp(ILogger logger, MychainClient client) {
        this.network = client.getNetwork();
        this.timerTaskManager = client.getTimerTaskManager();
        this.timeout = client.getMychainClientEnv().getRequestOption().getSendRequestTimeoutMs();
        this.logger = logger;
    }

    public boolean init(VerifiedBlock trustedBlock, AbstractSpvProxy proxy, int maxBlockAmount, int intervalMs) {
        if (this.network == null || this.timerTaskManager == null) {
            this.logger.error("network or task mgr is null");
            return false;
        }
        this.verifiedBlock = trustedBlock;
        this.proxy = proxy;
        this.watchTopic(SYSTEM_EVENT_ACTIVATE_NODE);
        this.watchTopic(SYSTEM_EVENT_DELETE_NODE);
        if (proxy.getUntrustedEnv().booleanValue()) {
            SpvTask task = new SpvTask(this, this.network, this.logger, this.verifiedBlock.getBlockNum(), maxBlockAmount, intervalMs, this.timeout);
            this.taskId = this.timerTaskManager.registerTask(task);
            this.logger.debug("taskId is {}", (Object)this.taskId);
        }
        return true;
    }

    public boolean stop() {
        this.logger.info("taskManager stop");
        if (this.taskId > 0L) {
            this.timerTaskManager.unRegisterTask(this.taskId);
            this.taskId = 0L;
        }
        return true;
    }

    public long verifyBlocks(long startNum, List<BlockHeaderInfo> headerInfos) {
        for (int i = 0; i < headerInfos.size(); ++i) {
            long blockNum = headerInfos.get(i).getBlockHeader().getNumber().longValue();
            if (blockNum != startNum + 1L) {
                this.logger.error("verifyBlocks, start num:{}, block header number:{}", (Object)startNum, (Object)blockNum);
                break;
            }
            boolean result = this.verifyBlockHeader(this.verifiedBlock, headerInfos.get(i));
            if (!result) {
                this.logger.error("verifyBlocks, VerifyBlockHeader failed, blockNum:{}", (Object)blockNum);
                break;
            }
            Set<PublicKey> publicKeys = this.checkEvent(headerInfos.get(i), this.verifiedBlock.getPublicKeys());
            if (publicKeys == null || publicKeys.isEmpty()) {
                this.logger.error("verifyBlocks, publicKeys is null");
                break;
            }
            this.verifiedBlock.setPublicKeys(publicKeys);
            if (this.proxy != null) {
                ArrayList<BlockHeaderProof> proofs = new ArrayList<BlockHeaderProof>();
                BlockHeaderProof proof = new BlockHeaderProof(headerInfos.get(i).getProof().getProof(), headerInfos.get(i).getBlockHeader());
                proofs.add(proof);
                this.proxy.writeBlockProof(proofs);
            } else {
                this.logger.error("verifyBlocks, proxy is null");
            }
            this.verifiedBlock.setVersion(headerInfos.get(i).getBlockHeader().getVersion());
            this.verifiedBlock.setBlockNum(headerInfos.get(i).getBlockHeader().getNumber());
            this.verifiedBlock.setBlockHash(headerInfos.get(i).getBlockHeader().getHash());
            this.logger.debug("verifyBlocks, verifiedBlock version:{}, blockNum:{}, blockHash:{}", this.verifiedBlock.getVersion(), this.verifiedBlock.getBlockNum(), this.verifiedBlock.getBlockHash());
            ++startNum;
        }
        return startNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchTopic(String topic) {
        SpvImp spvImp = this;
        synchronized (spvImp) {
            this.logFilter.addTopic(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchIdentity(Hash id) {
        SpvImp spvImp = this;
        synchronized (spvImp) {
            this.logFilter.addIdentity(id);
        }
    }

    public boolean verifyAccount(Account account, BigInteger blockNum) {
        this.logger.info("verifyAccount,account : {},blockNum : {}", (Object)account.toString(), (Object)blockNum);
        QueryStateProofRequest request = new QueryStateProofRequest(account.getIdentity(), blockNum);
        QueryStateProofResponse response = (QueryStateProofResponse)this.network.sendSyncRequest(request, new Hash(), this.timeout);
        return response != null && response.getErrorCode() == ErrorCode.SUCCESS && this.verifyAccount(response.getProof(), account, blockNum);
    }

    public boolean verifyContract(Contract contract, BigInteger blockNum) {
        this.logger.info("verifyContract,contract : {},blockNum : {}", (Object)contract.toString(), (Object)blockNum);
        QueryStateProofRequest request = new QueryStateProofRequest(contract.getIdentity(), blockNum);
        QueryStateProofResponse response = (QueryStateProofResponse)this.network.sendSyncRequest(request, new Hash(), this.timeout);
        return response != null && response.getErrorCode() == ErrorCode.SUCCESS && this.verifyContract(response.getProof(), contract, blockNum);
    }

    public boolean verifyTransaction(Hash txHash) {
        this.logger.debug("verifyTransaction,txHash : {}", (Object)txHash);
        QueryTransactionProofRequest request = new QueryTransactionProofRequest(txHash);
        QueryTransactionProofResponse response = (QueryTransactionProofResponse)this.network.sendSyncRequest(request, new Hash(), this.timeout);
        return response != null && response.getErrorCode() == ErrorCode.SUCCESS && this.verifyTransaction(response.getProof(), txHash);
    }

    public boolean verifyReceipt(Hash txHash, TransactionReceipt receipt) {
        this.logger.debug("verifyReceipt hash: {}", (Object)txHash);
        QueryReceiptProofRequest request = new QueryReceiptProofRequest(txHash);
        QueryReceiptProofResponse response = (QueryReceiptProofResponse)this.network.sendSyncRequest(request, new Hash(), this.timeout);
        return response != null && response.getErrorCode() == ErrorCode.SUCCESS && this.verifyReceipt(response.getProof(), receipt);
    }

    public boolean verifyAccount(WorldStateProof proof, Account account, BigInteger blockNum) {
        if (this.proxy == null) {
            return false;
        }
        BlockHeaderProof headerProof = this.proxy.readBlockProof(blockNum);
        if (headerProof == null) {
            this.logger.error("verifyAccount, readBlockProof failed");
            return false;
        }
        if (!proof.getStateRoot().hexStrValue().equalsIgnoreCase(headerProof.getBlockHeader().getStateRoot().hexStrValue())) {
            this.logger.error("verifyAccount, check state root failed");
            return false;
        }
        return this.verifyMPTProof(proof.getStateRoot(), proof.getWorldStateNodeList(), account.toStorageRlp());
    }

    public boolean verifyContract(WorldStateProof proof, Contract contract, BigInteger blockNum) {
        if (this.proxy == null) {
            return false;
        }
        BlockHeaderProof headerProof = this.proxy.readBlockProof(blockNum);
        if (headerProof == null) {
            this.logger.error("verifyContract, readBlockProof failed");
            return false;
        }
        if (!proof.getStateRoot().hexStrValue().equalsIgnoreCase(headerProof.getBlockHeader().getStateRoot().hexStrValue())) {
            this.logger.error("verifyContract, check state root failed");
            return false;
        }
        return this.verifyMPTProof(proof.getStateRoot(), proof.getWorldStateNodeList(), contract.toStorageRlp());
    }

    public boolean verifyTransaction(TransactionProof proof, Hash txHash) {
        if (this.proxy == null) {
            return false;
        }
        BlockHeaderProof headerProof = this.proxy.readBlockProof(proof.getBlockNum());
        if (headerProof == null) {
            this.logger.error("verifyTransaction, readBlockProof failed");
            return false;
        }
        if (!proof.getTxRoot().hexStrValue().equalsIgnoreCase(headerProof.getBlockHeader().getTransactionRoot().hexStrValue())) {
            this.logger.error("verifyTransaction, check tx root failed");
            return false;
        }
        return this.verifyMerkleTreeProof(proof.getTxRoot(), proof.getBranches(), txHash, proof.getIndex(), proof.getSize());
    }

    public boolean verifyReceipt(ReceiptProof proof, TransactionReceipt receipt) {
        if (this.proxy == null) {
            return false;
        }
        BlockHeaderProof headerProof = this.proxy.readBlockProof(proof.getBlockNumber());
        if (headerProof == null) {
            this.logger.error("verifyReceipt, readBlockProof failed");
            return false;
        }
        if (!proof.getReceiptRoot().hexStrValue().equalsIgnoreCase(headerProof.getBlockHeader().getReceiptRoot().hexStrValue())) {
            this.logger.error("verifyReceipt, check receipt root failed");
            return false;
        }
        Hash receiptHash = new Hash(HashFactory.getHash(HashTypeEnum.SHA256).hash(receipt.toRlp()));
        return this.verifyMerkleTreeProof(proof.getReceiptRoot(), proof.getBranches(), receiptHash, proof.getIndex(), proof.getSize());
    }

    public boolean verifyBlockHeader(VerifiedBlock block, BlockHeaderInfo info) {
        if (!info.getBlockHeader().getParentHash().hexStrValue().equalsIgnoreCase(block.getBlockHash().hexStrValue()) || info.getBlockHeader().getNumber().compareTo(block.getBlockNum().add(BigInteger.ONE)) != 0) {
            this.logger.error("verifyBlockHeader, verify hash or block number failed");
            return false;
        }
        if (!info.getBlockHeader().getHash().hexStrValue().equalsIgnoreCase(BlockHeader.calcHash(info.getBlockHeader()))) {
            this.logger.error("verifyBlockHeader, check hash failed");
            return false;
        }
        Hash pksHash = Consensus.calcPKsMerkleRootHash(block.getPublicKeys());
        Hash digest = Consensus.calcProofHash(info.getBlockHeader().getParentHash(), info.getBlockHeader().getTransactionRoot(), pksHash, block.getPublicKeys().size(), info.getBlockHeader().getTimestamp());
        switch (info.getProof().getType()) {
            case PBFT: {
                PbftConsensusProofInfo pbftConsensusProofInfo = PbftConsensusProofInfo.decode(info.getProof().getProof());
                if (!Arrays.equals(pbftConsensusProofInfo.getSignatureInfo().getDigest(), digest.getValue())) {
                    this.logger.error("verifyBlockHeader, check proof digest failed");
                    return false;
                }
                if (pbftConsensusProofInfo.getSignatureInfo().getSeq() != block.getBlockNum().longValue() + 1L) {
                    this.logger.error("verifyBlockHeader, check seq failed");
                    return false;
                }
                if (!Pbft.verifyPbftConsensusProof(block.getPublicKeys(), pbftConsensusProofInfo)) break;
                return true;
            }
            case HONEYBADGER: {
                HBConsensusProofInfo hbConsensusProofInfo = HBConsensusProofInfo.decode(info.getProof().getProof());
                if (!Arrays.equals(hbConsensusProofInfo.getHbSignatureInfo().getDigest(), digest.getValue())) {
                    this.logger.error("verifyBlockHeader, check proof digest failed");
                    return false;
                }
                if (hbConsensusProofInfo.getHbSignatureInfo().getView() != block.getBlockNum().longValue() + 1L) {
                    this.logger.error("verifyLastBlockProof: check view failed");
                    return false;
                }
                if (!HoneyBadger.verifyHBConsensusProof(block.getPublicKeys(), hbConsensusProofInfo)) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean verifyMPTProof(Hash root, List<WorldStateNode> worldStateNodes, byte[] rlpData) {
        if (worldStateNodes.isEmpty()) {
            return false;
        }
        if (!root.hexStrValue().equals(ByteUtils.toHexString(HashFactory.getHash().hash(worldStateNodes.get(0).getData())))) {
            return false;
        }
        String soHex = ByteUtils.toHexString(rlpData);
        for (int i = 0; i < worldStateNodes.size(); ++i) {
            if (i != worldStateNodes.size() - 1) {
                byte[] nextHash = HashFactory.getHash().hash(worldStateNodes.get(i + 1).getData());
                int found = ByteUtils.toHexString(worldStateNodes.get(i).getData()).indexOf(ByteUtils.toHexString(nextHash));
                if (found != -1) {
                    this.logger.info("find hash {} in node_value {}", (Object)ByteUtils.toHexString(nextHash), (Object)ByteUtils.toHexString(worldStateNodes.get(i).getData()));
                    continue;
                }
                this.logger.info("can not find hash {} in node_value {}", (Object)ByteUtils.toHexString(nextHash), (Object)ByteUtils.toHexString(worldStateNodes.get(i).getData()));
                return false;
            }
            int found = ByteUtils.toHexString(worldStateNodes.get(i).getData()).indexOf(soHex);
            if (found != -1) {
                this.logger.info("find hash {} in node_value of the leaf {}", (Object)soHex, (Object)ByteUtils.toHexString(worldStateNodes.get(i).getData()));
                continue;
            }
            this.logger.info("can not find hash {} in node_value of the leaf {}", (Object)soHex, (Object)ByteUtils.toHexString(worldStateNodes.get(i).getData()));
            return false;
        }
        return true;
    }

    private boolean verifyMerkleTreeProof(Hash root, List<Hash> branches, Hash txHash, int index, int size) {
        return MerkleTree.verify(index, txHash, root, branches, size);
    }

    private Set<PublicKey> checkEvent(BlockHeaderInfo headerInfo, Set<PublicKey> publicKeys) {
        HashSet<PublicKey> pubKeys = new HashSet();
        if (this.logFilter.isMatch(headerInfo.getBlockHeader())) {
            BlockBodyInfo blockBody = this.readBlockBody(headerInfo.getBlockHeader().getHash());
            if (blockBody == null) {
                this.logger.error("checkEvent, read block error.");
                return null;
            }
            boolean result = this.verifyBlockBody(headerInfo, blockBody.getBody());
            if (!result) {
                this.logger.error("checkEvent, verify block body error.");
                return null;
            }
            pubKeys = this.handleEvent(headerInfo.getBlockHeader(), blockBody.getBody(), publicKeys);
            return pubKeys;
        }
        this.logger.debug("checkEvent, log_filter is not match.");
        return publicKeys;
    }

    private BlockBodyInfo readBlockBody(Hash blockHash) {
        this.logger.debug("readBlockBody, block hash is {}.", (Object)blockHash.hexStrValue());
        if (this.network == null) {
            this.logger.error("readBlockBody, network is null.");
            return null;
        }
        ArrayList<Hash> blockHashes = new ArrayList<Hash>();
        blockHashes.add(blockHash);
        QueryBlockBodiesRequest request = new QueryBlockBodiesRequest(blockHashes);
        QueryBlockBodiesResponse response = (QueryBlockBodiesResponse)this.network.sendSyncRequest(request, new Hash(), this.timeout);
        if (response == null || response.getErrorCode() != ErrorCode.SUCCESS || response.getBlockBodyInfos().isEmpty()) {
            return null;
        }
        BlockBodyInfo blockBodyInfo = new BlockBodyInfo();
        blockBodyInfo.setBlockHash(response.getBlockBodyInfos().get(0).getBlockHash());
        blockBodyInfo.setBody(response.getBlockBodyInfos().get(0).getBody());
        return blockBodyInfo;
    }

    private boolean verifyBlockBody(BlockHeaderInfo headerInfo, BlockBody body) {
        Vector<Hash> txHashes = new Vector<Hash>();
        for (Transaction tx : body.getTransactionList()) {
            if (tx.getHash().equals(Hash.ZERO)) {
                txHashes.add(Hash.ZERO);
                continue;
            }
            txHashes.add(tx.getHash());
        }
        if (txHashes.isEmpty() || !MerkleTree.root(txHashes).hexStrValue().equalsIgnoreCase(headerInfo.getBlockHeader().getTransactionRoot().hexStrValue())) {
            this.logger.error("verifyBlockBody, check tx root failed");
            return false;
        }
        Vector<Hash> txReceiptHashes = new Vector<Hash>();
        for (TransactionReceipt receipt : body.getReceiptList()) {
            IHash iHash = HashFactory.getHash(HashTypeEnum.SHA256);
            byte[] hash = iHash.hash(receipt.toRlp());
            txReceiptHashes.add(new Hash(hash));
        }
        return !txReceiptHashes.isEmpty() && MerkleTree.root(txReceiptHashes).hexStrValue().equalsIgnoreCase(headerInfo.getBlockHeader().getReceiptRoot().hexStrValue());
    }

    private Set<PublicKey> handleEvent(BlockHeader header, BlockBody body, Set<PublicKey> pubKeys) {
        int index = 0;
        for (TransactionReceipt receipt : body.getReceiptList()) {
            for (LogEntry log : receipt.getLogs()) {
                if (SYSTEM_CONTRACT_NODE.hexStrValue().equalsIgnoreCase(body.getTransactionList().get(index).getTo().hexStrValue())) {
                    PublicKey pubKey;
                    if (Objects.equals(SYSTEM_EVENT_ACTIVATE_NODE, log.getTopics().get(0))) {
                        pubKey = this.parseLogData(log.getLogData());
                        pubKeys.add(pubKey);
                        if (this.proxy != null) {
                            this.proxy.onNodeChangeEvent(header, pubKey, ContractNodeState.NODE_STATE_NORMAL);
                        }
                        this.logger.debug("HandleEvent, add pub_key, pub_key size:%d", (Object)pubKeys.size());
                        continue;
                    }
                    if (Objects.equals(SYSTEM_EVENT_DELETE_NODE, log.getTopics().get(0))) {
                        pubKey = this.parseLogData(log.getLogData());
                        if (!pubKeys.contains(pubKey)) continue;
                        pubKeys.remove(pubKey);
                        if (this.proxy != null) {
                            this.proxy.onNodeChangeEvent(header, pubKey, ContractNodeState.NODE_STATE_DELETED);
                        }
                        this.logger.debug("HandleEvent, remove pub_key, pub_key size:%d", (Object)pubKeys.size());
                        continue;
                    }
                }
                if (this.logFilter.getIdentities().contains(log.getFrom()) && this.proxy != null) {
                    this.proxy.onUserEvent(header, body.getTransactionList().get(index), receipt);
                    continue;
                }
                if (this.logFilter.getIdentities().contains(log.getTo()) && this.proxy != null) {
                    this.proxy.onUserEvent(header, body.getTransactionList().get(index), receipt);
                    continue;
                }
                for (String topic : this.logFilter.getTopics()) {
                    if (!log.matchTopic(topic)) continue;
                    this.logger.debug("handleEvent, match topic,topic is{}", (Object)topic);
                    if (this.proxy == null) continue;
                    this.proxy.onUserEvent(header, body.getTransactionList().get(index), receipt);
                }
            }
            ++index;
        }
        return pubKeys;
    }

    private PublicKey parseLogData(byte[] logData) {
        return new PublicKey(ByteUtils.toHexString(this.decodeReturnData(logData, 0)));
    }

    private byte[] decodeReturnData(byte[] data, int pos) {
        byte[] temp = new byte[32];
        System.arraycopy(data, pos * 32, temp, 0, 32);
        BigInteger offset = new BigInteger(temp);
        byte[] countBytes = new byte[32];
        System.arraycopy(data, offset.intValue(), countBytes, 0, 32);
        BigInteger count = new BigInteger(countBytes);
        byte[] decodedValue = new byte[count.intValue()];
        System.arraycopy(data, offset.intValue() + 32, decodedValue, 0, count.intValue());
        return decodedValue;
    }
}

