/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.task;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.BaseService;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.transaction.TransactionReceiptResponse;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;

public class QueryReceiptTask
extends AbstractTask {
    private TransactionReceiptResponse response;
    private IAsyncCallback callback;
    private Hash hash;
    private BaseFixedSizeByteArray.Fixed20ByteArray groupId;
    private long endTimestamp;
    private BaseService baseService;

    public QueryReceiptTask(BaseService baseService, Integer interval, ILogger logger, TransactionReceiptResponse response, IAsyncCallback callback, Hash hash, BaseFixedSizeByteArray.Fixed20ByteArray groupId, long endTimestamp) {
        super(interval, TaskType.ONCE, logger);
        this.baseService = baseService;
        this.response = response;
        this.callback = callback;
        this.hash = hash;
        this.groupId = groupId;
        this.endTimestamp = endTimestamp;
    }

    @Override
    public void run() {
        if (this.response == null || this.callback == null || this.endTimestamp == 0L || this.baseService == null) {
            return;
        }
        this.logger.debug("QueryReceiptTask, query receipt hash:{}", (Object)this.hash);
        int result = this.baseService.queryReceiptAsync(this.response, this.callback, this.hash, this.groupId, this.endTimestamp);
        if (ErrorCode.SUCCESS.getErrorCode() != result) {
            this.logger.error("QueryReceiptTask, query receipt error code:{},response:{}", (Object)ErrorCode.valueOf(result).getErrorCode(), (Object)this.response.toString());
            this.response.setErrorCode(ErrorCode.forNumber(result));
            this.callback.onResponse(result, this.response);
        }
    }
}

