/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto;

import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.utils.ReflectionUtil;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;

public class CryptoUtils {
    public static ECPoint publicPointFromPrivate(ECDomainParameters curve, BigInteger privKey) {
        if (privKey.bitLength() > curve.getN().bitLength()) {
            privKey = privKey.mod(curve.getN());
        }
        return new FixedPointCombMultiplier().multiply(curve.getG(), privKey);
    }

    public static ECPoint publicPointFromPrivate(String curveName, BigInteger privKey) {
        X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)curveName);
        ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
        return CryptoUtils.publicPointFromPrivate(CURVE, privKey);
    }

    public static byte[] getPubkeyFp(byte[] pubkey) {
        byte[] hash = HashFactory.getHash().hash(pubkey);
        return Arrays.copyOfRange(hash, 0, 4);
    }

    public static void initMaxKeySize() {
        String errorString = "Failed to modify key-length permissions";
        try {
            int newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (newMaxKeyLength < 256) {
                Object allPermissionCollection = ReflectionUtil.newInstance(Class.forName("javax.crypto.CryptoAllPermissionCollection"), new Object[0]);
                ReflectionUtil.setFieldValue(allPermissionCollection, "all_allowed", true);
                Object allPermissions = ReflectionUtil.newInstance(Class.forName("javax.crypto.CryptoPermissions"), new Object[0]);
                Field f = ReflectionUtil.getDeclaredField(allPermissions, "perms");
                f.setAccessible(true);
                ((Map)f.get(allPermissions)).put("*", allPermissionCollection);
                Class<?> c = Class.forName("javax.crypto.JceSecurityManager");
                f = c.getDeclaredField("defaultPolicy");
                f.setAccessible(true);
                Field mf = Field.class.getDeclaredField("modifiers");
                mf.setAccessible(true);
                mf.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                f.set(null, allPermissions);
                newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(errorString, e);
        }
    }
}

