/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.cipher;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.CipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.util.Random;
import javax.crypto.ShortBufferException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;

public class SM4CbcPkeyCipherV1
extends CipherBase {
    private static final int IVLEN = 16;
    private static final int KEYLEN = 16;

    public SM4CbcPkeyCipherV1(byte[] key) {
        super(key);
        if (ArrayUtils.isEmpty((byte[])key)) {
            key = new byte[16];
            for (int i = 0; i < 16; ++i) {
                key[i] = (byte)new Random().nextInt(256);
            }
            this.key = key;
        }
    }

    @Override
    public byte[] encrypt(byte[] plaintext) {
        byte[] iv = new byte[16];
        for (int i = 0; i < 16; ++i) {
            iv[i] = (byte)new Random().nextInt(256);
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(this.key), iv);
        CBCBlockCipher cbcBlockCipher = new CBCBlockCipher((BlockCipher)new SM4Engine());
        cbcBlockCipher.init(true, (CipherParameters)parametersWithIV);
        try {
            PKCS5Padding pkcs5Padding = new PKCS5Padding(16);
            int realInputLen = plaintext.length + pkcs5Padding.padLength(plaintext.length);
            byte[] realInput = new byte[realInputLen];
            System.arraycopy(plaintext, 0, realInput, 0, plaintext.length);
            pkcs5Padding.padWithLen(realInput, plaintext.length, pkcs5Padding.padLength(plaintext.length));
            byte[] realOutput = new byte[realInputLen];
            int count = realInputLen >> 4;
            for (int i = 0; i < count; ++i) {
                cbcBlockCipher.processBlock(realInput, i * 16, realOutput, i * 16);
            }
            byte[] cipherText = new byte[18 + realInputLen];
            System.arraycopy(this.getAlgo().toBytes(), 0, cipherText, 0, 2);
            System.arraycopy(iv, 0, cipherText, 2, 16);
            System.arraycopy(realOutput, 0, cipherText, 18, realInputLen);
            return cipherText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        if (ArrayUtils.isEmpty((byte[])this.key)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "secret key is empty");
        }
        byte[] iv = new byte[16];
        System.arraycopy(ciphertext, 2, iv, 0, 16);
        ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(this.key), iv);
        CBCBlockCipher cbcBlockCipher = new CBCBlockCipher((BlockCipher)new SM4Engine());
        cbcBlockCipher.init(false, (CipherParameters)parametersWithIV);
        byte[] plainText = new byte[ciphertext.length - 2 - 16];
        int count = plainText.length >> 4;
        for (int i = 0; i < count; ++i) {
            cbcBlockCipher.processBlock(ciphertext, 18 + i * 16, plainText, i * 16);
        }
        PKCS5Padding pkcs5Padding = new PKCS5Padding(16);
        int start = pkcs5Padding.unpad(plainText, 0, plainText.length);
        byte[] realOuput = new byte[start];
        System.arraycopy(plainText, 0, realOuput, 0, start);
        return realOuput;
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.CIPHER_SM4_CBC_LOCAL_V1;
    }

    public static void main(String[] args) {
        byte[] key = Hex.decode((String)"3c6140069976191f7ab84792280920ec");
        SM4CbcPkeyCipherV1 sm4CbcPkeyCipherV1 = new SM4CbcPkeyCipherV1(key);
        byte[] cipherText = sm4CbcPkeyCipherV1.encrypt("hhhhhhhhhhhhhhhh".getBytes());
        System.out.println(Hex.toHexString((byte[])cipherText));
        byte[] plainText = sm4CbcPkeyCipherV1.decrypt(cipherText);
        System.out.println(new String(plainText));
    }

    public static class PKCS5Padding {
        private int blockSize;

        PKCS5Padding(int blockSize) {
            this.blockSize = blockSize;
        }

        public void padWithLen(byte[] in, int off, int len) throws ShortBufferException {
            if (in == null) {
                return;
            }
            if (off + len > in.length) {
                throw new ShortBufferException("Buffer too small to hold padding");
            }
            byte paddingOctet = (byte)(len & 0xFF);
            for (int i = 0; i < len; ++i) {
                in[i + off] = paddingOctet;
            }
        }

        public int unpad(byte[] in, int off, int len) {
            if (in == null || len == 0) {
                return 0;
            }
            byte lastByte = in[off + len - 1];
            int padValue = lastByte & 0xFF;
            if (padValue < 1 || padValue > this.blockSize) {
                return -1;
            }
            int start = off + len - (lastByte & 0xFF);
            if (start < off) {
                return -1;
            }
            for (int i = 0; i < (lastByte & 0xFF); ++i) {
                if (in[start + i] == lastByte) continue;
                return -1;
            }
            return start;
        }

        public int padLength(int len) {
            int paddingOctet = this.blockSize - len % this.blockSize;
            return paddingOctet;
        }
    }
}

