/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.hash;

import com.alipay.mychain.sdk.crypto.Type;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Hash
implements Type<byte[]>,
Serializable,
Comparable<Hash> {
    public static final int LENGTH = 256;
    public static final int LENGTH_BYTE = 32;
    public static final Hash ZERO = new Hash();
    private static final long serialVersionUID = -3162581821891022131L;
    private byte[] data = new byte[32];

    public Hash() {
        Arrays.fill(this.data, (byte)0);
    }

    public Hash(byte[] value) {
        try {
            if (value.length != 32) {
                throw new IllegalArgumentException(" hash length invalidate!");
            }
            System.arraycopy(value, 0, this.data, 0, 32);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public Hash(Hash from) {
        this(from.getValue());
    }

    public Hash(String hexString) {
        try {
            byte[] value = ByteUtils.hexStringToBytes(hexString);
            if (value.length != 32) {
                throw new IllegalArgumentException(" hash length invalidate!");
            }
            System.arraycopy(value, 0, this.data, 0, 32);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public String hexStrValue() {
        return ByteUtils.toHexString(this.data);
    }

    @Override
    public byte[] getValue() {
        return this.data;
    }

    @Override
    public int compareTo(Hash another) {
        return this.hexStrValue().compareTo(another.hexStrValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hash hash = (Hash)o;
        return Arrays.equals(this.data, hash.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return this.hexStrValue();
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] value) {
        if (value.length != 32) {
            throw new IllegalArgumentException(" hash length invalidate!");
        }
        System.arraycopy(value, 0, this.data, 0, 32);
    }

    public boolean isEmpty() {
        return this.getValue() == null || this.hexStrValue().isEmpty() || Arrays.equals(this.getValue(), new Hash().getValue());
    }
}

