/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class TransactionCacheInfo
extends MychainObject {
    private long unverifiedQueueLimit;
    private long verifiedQueueLimit;
    private long unverifiedQueueUsage;
    private long verifiedQueueUsage;

    public static TransactionCacheInfo builder(long unverifiedQueueLimit, long verifiedQueueLimit, long unverifiedQueueUsage, long verifiedQueueUsage) {
        TransactionCacheInfo transactionCacheInfo = new TransactionCacheInfo();
        transactionCacheInfo.unverifiedQueueLimit = unverifiedQueueLimit;
        transactionCacheInfo.verifiedQueueLimit = verifiedQueueLimit;
        transactionCacheInfo.unverifiedQueueUsage = unverifiedQueueUsage;
        transactionCacheInfo.verifiedQueueUsage = verifiedQueueUsage;
        return transactionCacheInfo;
    }

    public long getUnverifiedQueueLimit() {
        return this.unverifiedQueueLimit;
    }

    public long getVerifiedQueueLimit() {
        return this.verifiedQueueLimit;
    }

    public long getUnverifiedQueueUsage() {
        return this.unverifiedQueueUsage;
    }

    public long getVerifiedQueueUsage() {
        return this.verifiedQueueUsage;
    }

    @Override
    public byte[] toRlp() {
        byte[] unverifiedQueueLimitBytes = Rlp.encodeLong(this.unverifiedQueueLimit);
        byte[] verifiedQueueLimitBytes = Rlp.encodeLong(this.verifiedQueueLimit);
        byte[] unverifiedQueueUsageBytes = Rlp.encodeLong(this.unverifiedQueueUsage);
        byte[] verifiedQueueUsageBytes = Rlp.encodeLong(this.verifiedQueueUsage);
        return Rlp.encodeList(unverifiedQueueLimitBytes, verifiedQueueLimitBytes, unverifiedQueueUsageBytes, verifiedQueueUsageBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.unverifiedQueueLimit = ByteUtils.byteArrayToLong(((RlpElement)list.get(0)).getRlpData());
        this.verifiedQueueLimit = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
        this.unverifiedQueueUsage = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.unverifiedQueueUsage = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("unverified_queue_limit", (Object)this.unverifiedQueueLimit);
        jsonObject.put("verified_queue_limit", (Object)this.verifiedQueueLimit);
        jsonObject.put("unverified_queue_usage", (Object)this.unverifiedQueueUsage);
        jsonObject.put("verified_queue_usage", (Object)this.unverifiedQueueUsage);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.unverifiedQueueLimit = jsonObject.getLong("unverified_queue_limit");
        this.verifiedQueueLimit = jsonObject.getLong("verified_queue_limit");
        this.unverifiedQueueUsage = jsonObject.getLong("unverified_queue_usage");
        this.unverifiedQueueUsage = jsonObject.getLong("verified_queue_usage");
    }
}

