/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CancelEventRequest
extends Request {
    private List<BigInteger> ids;

    public CancelEventRequest(List<BigInteger> ids) {
        super(MessageType.MSG_TYPE_EVENT_REQ_CANCEL);
        this.ids = ids;
    }

    public CancelEventRequest() {
        super(MessageType.MSG_TYPE_EVENT_REQ_CANCEL);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.ids != null && this.ids.size() > 0;
    }

    public List<BigInteger> getIds() {
        return this.ids;
    }

    public void setIds(List<BigInteger> ids) {
        this.ids = ids;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (BigInteger item : this.ids) {
            data.add(Rlp.encodeBigInteger(item));
        }
        return Rlp.encodeList(super.toRlp(), Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.ids = new ArrayList<BigInteger>();
        RlpList data = (RlpList)list.get(1);
        for (RlpElement element : data) {
            this.ids.add(ByteUtils.byteArrayToBigInteger(element.getRlpData()));
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONArray jsonArray = new JSONArray();
        if (this.ids != null) {
            for (BigInteger item : this.ids) {
                jsonArray.add((Object)item);
            }
        }
        jsonObject.put("filter_ids", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.ids = new ArrayList<BigInteger>();
        JSONArray jsonArray = jsonObject.getJSONArray("filter_ids");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                this.ids.add(TypeUtils.castToBigInteger(iterator.next()));
            }
        }
    }
}

